/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm;

import co.elastic.clients.elasticsearch.ilm.Phases;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IlmPolicy
implements JsonpSerializable {
    private final Phases phases;
    private final Map<String, JsonData> meta;
    public static final JsonpDeserializer<IlmPolicy> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IlmPolicy::setupIlmPolicyDeserializer);

    private IlmPolicy(Builder builder) {
        this.phases = ApiTypeHelper.requireNonNull(builder.phases, this, "phases");
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
    }

    public static IlmPolicy of(Function<Builder, ObjectBuilder<IlmPolicy>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Phases phases() {
        return this.phases;
    }

    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("phases");
        this.phases.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.meta.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupIlmPolicyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::phases, Phases._DESERIALIZER, "phases");
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IlmPolicy> {
        private Phases phases;
        @Nullable
        private Map<String, JsonData> meta;

        public Builder() {
        }

        private Builder(IlmPolicy instance) {
            this.phases = instance.phases;
            this.meta = instance.meta;
        }

        public final Builder phases(Phases value) {
            this.phases = value;
            return this;
        }

        public final Builder phases(Function<Phases.Builder, ObjectBuilder<Phases>> fn) {
            return this.phases(fn.apply(new Phases.Builder()).build());
        }

        public final Builder meta(Map<String, JsonData> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        public final Builder meta(String key, JsonData value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IlmPolicy build() {
            this._checkSingleUse();
            return new IlmPolicy(this);
        }
    }
}

