/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.features;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Feature
implements JsonpSerializable {
    private final String name;
    private final String description;
    public static final JsonpDeserializer<Feature> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Feature::setupFeatureDeserializer);

    private Feature(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.description = ApiTypeHelper.requireNonNull(builder.description, this, "description");
    }

    public static Feature of(Function<Builder, ObjectBuilder<Feature>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("description");
        generator.write(this.description);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupFeatureDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Feature> {
        private String name;
        private String description;

        public Builder() {
        }

        private Builder(Feature instance) {
            this.name = instance.name;
            this.description = instance.description;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder description(String value) {
            this.description = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Feature build() {
            this._checkSingleUse();
            return new Feature(this);
        }
    }
}

