/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.TotalHitsRelation;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpDeserializerBase;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpMappingException;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.LazyDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.EnumSet;
import java.util.function.Function;

@JsonpDeserializable
public class TotalHits
implements JsonpSerializable {
    private final TotalHitsRelation relation;
    private final long value;
    public static final JsonpDeserializer<TotalHits> _DESERIALIZER = new LazyDeserializer<TotalHits>(() -> {
        final JsonpDeserializer<Long> longDeserializer = JsonpDeserializer.longDeserializer();
        EnumSet<JsonParser.Event> events = EnumSet.of(JsonParser.Event.START_OBJECT);
        events.addAll(longDeserializer.acceptedEvents());
        return new JsonpDeserializerBase<TotalHits>(events){

            @Override
            public TotalHits deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
                Builder builder = new Builder();
                if (longDeserializer.acceptedEvents().contains(event)) {
                    return builder.relation(TotalHitsRelation.Eq).value((Long)longDeserializer.deserialize(parser, mapper, event)).build();
                }
                JsonpUtils.expectEvent(parser, JsonParser.Event.START_OBJECT, event);
                block8: while ((event = parser.next()) != JsonParser.Event.END_OBJECT) {
                    JsonpUtils.expectEvent(parser, JsonParser.Event.KEY_NAME, event);
                    switch (parser.getString()) {
                        case "relation": {
                            builder.relation((TotalHitsRelation)TotalHitsRelation._DESERIALIZER.deserialize(parser, mapper));
                            continue block8;
                        }
                        case "value": {
                            builder.value((Long)longDeserializer.deserialize(parser, mapper));
                            continue block8;
                        }
                    }
                    throw new JsonpMappingException("Unknown field '" + parser.getString() + "'", parser.getLocation());
                }
                return builder.build();
            }
        };
    });

    private TotalHits(Builder builder) {
        this.relation = ApiTypeHelper.requireNonNull(builder.relation, this, "relation");
        this.value = ApiTypeHelper.requireNonNull(builder.value, (Object)this, "value", 0L);
    }

    public static TotalHits of(Function<Builder, ObjectBuilder<TotalHits>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final TotalHitsRelation relation() {
        return this.relation;
    }

    public final long value() {
        return this.value;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("relation");
        this.relation.serialize(generator, mapper);
        generator.writeKey("value");
        generator.write(this.value);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TotalHits> {
        private TotalHitsRelation relation;
        private Long value;

        public Builder() {
        }

        private Builder(TotalHits instance) {
            this.relation = instance.relation;
            this.value = instance.value;
        }

        public final Builder relation(TotalHitsRelation value) {
            this.relation = value;
            return this;
        }

        public final Builder value(long value) {
            this.value = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TotalHits build() {
            this._checkSingleUse();
            return new TotalHits(this);
        }
    }
}

