/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.FieldSuggester;
import co.elastic.clients.elasticsearch.core.search.FieldSuggesterVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Suggester
implements JsonpSerializable {
    private final Map<String, FieldSuggester> suggesters;
    @Nullable
    private final String text;
    public static final JsonpDeserializer<Suggester> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Suggester::setupSuggesterDeserializer);

    private Suggester(Builder builder) {
        this.suggesters = ApiTypeHelper.unmodifiable(builder.suggesters);
        this.text = builder.text;
    }

    public static Suggester of(Function<Builder, ObjectBuilder<Suggester>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, FieldSuggester> suggesters() {
        return this.suggesters;
    }

    @Nullable
    public final String text() {
        return this.text;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        for (Map.Entry<String, FieldSuggester> item0 : this.suggesters.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        if (this.text != null) {
            generator.writeKey("text");
            generator.write(this.text);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSuggesterDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::text, JsonpDeserializer.stringDeserializer(), "text");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> builder.suggesters((String)name, FieldSuggester._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper)));
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Suggester> {
        @Nullable
        private Map<String, FieldSuggester> suggesters = new HashMap<String, FieldSuggester>();
        @Nullable
        private String text;

        public final Builder suggesters(Map<String, FieldSuggester> map) {
            this.suggesters = Builder._mapPutAll(this.suggesters, map);
            return this;
        }

        public final Builder suggesters(String key, FieldSuggester value) {
            this.suggesters = Builder._mapPut(this.suggesters, key, value);
            return this;
        }

        public final Builder suggesters(String key, FieldSuggesterVariant value) {
            this.suggesters = Builder._mapPut(this.suggesters, key, value._toFieldSuggester());
            return this;
        }

        public final Builder suggesters(String key, Function<FieldSuggester.Builder, ObjectBuilder<FieldSuggester>> fn) {
            return this.suggesters(key, fn.apply(new FieldSuggester.Builder()).build());
        }

        public Builder() {
        }

        private Builder(Suggester instance) {
            this.text = instance.text;
            this.suggesters = instance.suggesters;
        }

        public final Builder text(@Nullable String value) {
            this.text = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Suggester build() {
            this._checkSingleUse();
            return new Suggester(this);
        }
    }
}

