/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SuggestFuzziness
implements JsonpSerializable {
    @Nullable
    private final String fuzziness;
    @Nullable
    private final Integer minLength;
    @Nullable
    private final Integer prefixLength;
    @Nullable
    private final Boolean transpositions;
    @Nullable
    private final Boolean unicodeAware;
    public static final JsonpDeserializer<SuggestFuzziness> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SuggestFuzziness::setupSuggestFuzzinessDeserializer);

    private SuggestFuzziness(Builder builder) {
        this.fuzziness = builder.fuzziness;
        this.minLength = builder.minLength;
        this.prefixLength = builder.prefixLength;
        this.transpositions = builder.transpositions;
        this.unicodeAware = builder.unicodeAware;
    }

    public static SuggestFuzziness of(Function<Builder, ObjectBuilder<SuggestFuzziness>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String fuzziness() {
        return this.fuzziness;
    }

    @Nullable
    public final Integer minLength() {
        return this.minLength;
    }

    @Nullable
    public final Integer prefixLength() {
        return this.prefixLength;
    }

    @Nullable
    public final Boolean transpositions() {
        return this.transpositions;
    }

    @Nullable
    public final Boolean unicodeAware() {
        return this.unicodeAware;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.fuzziness != null) {
            generator.writeKey("fuzziness");
            generator.write(this.fuzziness);
        }
        if (this.minLength != null) {
            generator.writeKey("min_length");
            generator.write(this.minLength.intValue());
        }
        if (this.prefixLength != null) {
            generator.writeKey("prefix_length");
            generator.write(this.prefixLength.intValue());
        }
        if (this.transpositions != null) {
            generator.writeKey("transpositions");
            generator.write(this.transpositions.booleanValue());
        }
        if (this.unicodeAware != null) {
            generator.writeKey("unicode_aware");
            generator.write(this.unicodeAware.booleanValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSuggestFuzzinessDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fuzziness, JsonpDeserializer.stringDeserializer(), "fuzziness");
        op.add(Builder::minLength, JsonpDeserializer.integerDeserializer(), "min_length");
        op.add(Builder::prefixLength, JsonpDeserializer.integerDeserializer(), "prefix_length");
        op.add(Builder::transpositions, JsonpDeserializer.booleanDeserializer(), "transpositions");
        op.add(Builder::unicodeAware, JsonpDeserializer.booleanDeserializer(), "unicode_aware");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SuggestFuzziness> {
        @Nullable
        private String fuzziness;
        @Nullable
        private Integer minLength;
        @Nullable
        private Integer prefixLength;
        @Nullable
        private Boolean transpositions;
        @Nullable
        private Boolean unicodeAware;

        public Builder() {
        }

        private Builder(SuggestFuzziness instance) {
            this.fuzziness = instance.fuzziness;
            this.minLength = instance.minLength;
            this.prefixLength = instance.prefixLength;
            this.transpositions = instance.transpositions;
            this.unicodeAware = instance.unicodeAware;
        }

        public final Builder fuzziness(@Nullable String value) {
            this.fuzziness = value;
            return this;
        }

        public final Builder minLength(@Nullable Integer value) {
            this.minLength = value;
            return this;
        }

        public final Builder prefixLength(@Nullable Integer value) {
            this.prefixLength = value;
            return this;
        }

        public final Builder transpositions(@Nullable Boolean value) {
            this.transpositions = value;
            return this;
        }

        public final Builder unicodeAware(@Nullable Boolean value) {
            this.unicodeAware = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SuggestFuzziness build() {
            this._checkSingleUse();
            return new SuggestFuzziness(this);
        }
    }
}

