/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SourceFilter
implements JsonpSerializable {
    @Nullable
    private final Boolean excludeVectors;
    private final List<String> excludes;
    private final List<String> includes;
    public static final JsonpDeserializer<SourceFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SourceFilter::setupSourceFilterDeserializer);

    private SourceFilter(Builder builder) {
        this.excludeVectors = builder.excludeVectors;
        this.excludes = ApiTypeHelper.unmodifiable(builder.excludes);
        this.includes = ApiTypeHelper.unmodifiable(builder.includes);
    }

    public static SourceFilter of(Function<Builder, ObjectBuilder<SourceFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean excludeVectors() {
        return this.excludeVectors;
    }

    public final List<String> excludes() {
        return this.excludes;
    }

    public final List<String> includes() {
        return this.includes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.excludeVectors != null) {
            generator.writeKey("exclude_vectors");
            generator.write(this.excludeVectors.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.excludes)) {
            generator.writeKey("excludes");
            generator.writeStartArray();
            for (String item0 : this.excludes) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.includes)) {
            generator.writeKey("includes");
            generator.writeStartArray();
            for (String item0 : this.includes) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSourceFilterDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::excludeVectors, JsonpDeserializer.booleanDeserializer(), "exclude_vectors");
        op.add(Builder::excludes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "excludes", "exclude");
        op.add(Builder::includes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "includes", "include");
        op.shortcutProperty("includes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SourceFilter> {
        @Nullable
        private Boolean excludeVectors;
        @Nullable
        private List<String> excludes;
        @Nullable
        private List<String> includes;

        public Builder() {
        }

        private Builder(SourceFilter instance) {
            this.excludeVectors = instance.excludeVectors;
            this.excludes = instance.excludes;
            this.includes = instance.includes;
        }

        public final Builder excludeVectors(@Nullable Boolean value) {
            this.excludeVectors = value;
            return this;
        }

        public final Builder excludes(List<String> list) {
            this.excludes = Builder._listAddAll(this.excludes, list);
            return this;
        }

        public final Builder excludes(String value, String ... values) {
            this.excludes = Builder._listAdd(this.excludes, value, values);
            return this;
        }

        public final Builder includes(List<String> list) {
            this.includes = Builder._listAddAll(this.includes, list);
            return this;
        }

        public final Builder includes(String value, String ... values) {
            this.includes = Builder._listAdd(this.includes, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SourceFilter build() {
            this._checkSingleUse();
            return new SourceFilter(this);
        }
    }
}

