/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.DirectGenerator;
import co.elastic.clients.elasticsearch.core.search.FieldSuggester;
import co.elastic.clients.elasticsearch.core.search.FieldSuggesterVariant;
import co.elastic.clients.elasticsearch.core.search.PhraseSuggestCollate;
import co.elastic.clients.elasticsearch.core.search.PhraseSuggestHighlight;
import co.elastic.clients.elasticsearch.core.search.SmoothingModel;
import co.elastic.clients.elasticsearch.core.search.SmoothingModelVariant;
import co.elastic.clients.elasticsearch.core.search.SuggesterBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PhraseSuggester
extends SuggesterBase
implements FieldSuggesterVariant {
    @Nullable
    private final PhraseSuggestCollate collate;
    @Nullable
    private final Double confidence;
    private final List<DirectGenerator> directGenerator;
    @Nullable
    private final Boolean forceUnigrams;
    @Nullable
    private final Integer gramSize;
    @Nullable
    private final PhraseSuggestHighlight highlight;
    @Nullable
    private final Double maxErrors;
    @Nullable
    private final Double realWordErrorLikelihood;
    @Nullable
    private final String separator;
    @Nullable
    private final Integer shardSize;
    @Nullable
    private final SmoothingModel smoothing;
    @Nullable
    private final String text;
    @Nullable
    private final Integer tokenLimit;
    public static final JsonpDeserializer<PhraseSuggester> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PhraseSuggester::setupPhraseSuggesterDeserializer);

    private PhraseSuggester(Builder builder) {
        super(builder);
        this.collate = builder.collate;
        this.confidence = builder.confidence;
        this.directGenerator = ApiTypeHelper.unmodifiable(builder.directGenerator);
        this.forceUnigrams = builder.forceUnigrams;
        this.gramSize = builder.gramSize;
        this.highlight = builder.highlight;
        this.maxErrors = builder.maxErrors;
        this.realWordErrorLikelihood = builder.realWordErrorLikelihood;
        this.separator = builder.separator;
        this.shardSize = builder.shardSize;
        this.smoothing = builder.smoothing;
        this.text = builder.text;
        this.tokenLimit = builder.tokenLimit;
    }

    public static PhraseSuggester of(Function<Builder, ObjectBuilder<PhraseSuggester>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public FieldSuggester.Kind _fieldSuggesterKind() {
        return FieldSuggester.Kind.Phrase;
    }

    @Nullable
    public final PhraseSuggestCollate collate() {
        return this.collate;
    }

    @Nullable
    public final Double confidence() {
        return this.confidence;
    }

    public final List<DirectGenerator> directGenerator() {
        return this.directGenerator;
    }

    @Nullable
    public final Boolean forceUnigrams() {
        return this.forceUnigrams;
    }

    @Nullable
    public final Integer gramSize() {
        return this.gramSize;
    }

    @Nullable
    public final PhraseSuggestHighlight highlight() {
        return this.highlight;
    }

    @Nullable
    public final Double maxErrors() {
        return this.maxErrors;
    }

    @Nullable
    public final Double realWordErrorLikelihood() {
        return this.realWordErrorLikelihood;
    }

    @Nullable
    public final String separator() {
        return this.separator;
    }

    @Nullable
    public final Integer shardSize() {
        return this.shardSize;
    }

    @Nullable
    public final SmoothingModel smoothing() {
        return this.smoothing;
    }

    @Nullable
    public final String text() {
        return this.text;
    }

    @Nullable
    public final Integer tokenLimit() {
        return this.tokenLimit;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.collate != null) {
            generator.writeKey("collate");
            this.collate.serialize(generator, mapper);
        }
        if (this.confidence != null) {
            generator.writeKey("confidence");
            generator.write(this.confidence.doubleValue());
        }
        if (ApiTypeHelper.isDefined(this.directGenerator)) {
            generator.writeKey("direct_generator");
            generator.writeStartArray();
            for (DirectGenerator item0 : this.directGenerator) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.forceUnigrams != null) {
            generator.writeKey("force_unigrams");
            generator.write(this.forceUnigrams.booleanValue());
        }
        if (this.gramSize != null) {
            generator.writeKey("gram_size");
            generator.write(this.gramSize.intValue());
        }
        if (this.highlight != null) {
            generator.writeKey("highlight");
            this.highlight.serialize(generator, mapper);
        }
        if (this.maxErrors != null) {
            generator.writeKey("max_errors");
            generator.write(this.maxErrors.doubleValue());
        }
        if (this.realWordErrorLikelihood != null) {
            generator.writeKey("real_word_error_likelihood");
            generator.write(this.realWordErrorLikelihood.doubleValue());
        }
        if (this.separator != null) {
            generator.writeKey("separator");
            generator.write(this.separator);
        }
        if (this.shardSize != null) {
            generator.writeKey("shard_size");
            generator.write(this.shardSize.intValue());
        }
        if (this.smoothing != null) {
            generator.writeKey("smoothing");
            this.smoothing.serialize(generator, mapper);
        }
        if (this.text != null) {
            generator.writeKey("text");
            generator.write(this.text);
        }
        if (this.tokenLimit != null) {
            generator.writeKey("token_limit");
            generator.write(this.tokenLimit.intValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPhraseSuggesterDeserializer(ObjectDeserializer<Builder> op) {
        SuggesterBase.setupSuggesterBaseDeserializer(op);
        op.add(Builder::collate, PhraseSuggestCollate._DESERIALIZER, "collate");
        op.add(Builder::confidence, JsonpDeserializer.doubleDeserializer(), "confidence");
        op.add(Builder::directGenerator, JsonpDeserializer.arrayDeserializer(DirectGenerator._DESERIALIZER), "direct_generator");
        op.add(Builder::forceUnigrams, JsonpDeserializer.booleanDeserializer(), "force_unigrams");
        op.add(Builder::gramSize, JsonpDeserializer.integerDeserializer(), "gram_size");
        op.add(Builder::highlight, PhraseSuggestHighlight._DESERIALIZER, "highlight");
        op.add(Builder::maxErrors, JsonpDeserializer.doubleDeserializer(), "max_errors");
        op.add(Builder::realWordErrorLikelihood, JsonpDeserializer.doubleDeserializer(), "real_word_error_likelihood");
        op.add(Builder::separator, JsonpDeserializer.stringDeserializer(), "separator");
        op.add(Builder::shardSize, JsonpDeserializer.integerDeserializer(), "shard_size");
        op.add(Builder::smoothing, SmoothingModel._DESERIALIZER, "smoothing");
        op.add(Builder::text, JsonpDeserializer.stringDeserializer(), "text");
        op.add(Builder::tokenLimit, JsonpDeserializer.integerDeserializer(), "token_limit");
    }

    public static class Builder
    extends SuggesterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PhraseSuggester> {
        @Nullable
        private PhraseSuggestCollate collate;
        @Nullable
        private Double confidence;
        @Nullable
        private List<DirectGenerator> directGenerator;
        @Nullable
        private Boolean forceUnigrams;
        @Nullable
        private Integer gramSize;
        @Nullable
        private PhraseSuggestHighlight highlight;
        @Nullable
        private Double maxErrors;
        @Nullable
        private Double realWordErrorLikelihood;
        @Nullable
        private String separator;
        @Nullable
        private Integer shardSize;
        @Nullable
        private SmoothingModel smoothing;
        @Nullable
        private String text;
        @Nullable
        private Integer tokenLimit;

        public Builder() {
        }

        private Builder(PhraseSuggester instance) {
            this.collate = instance.collate;
            this.confidence = instance.confidence;
            this.directGenerator = instance.directGenerator;
            this.forceUnigrams = instance.forceUnigrams;
            this.gramSize = instance.gramSize;
            this.highlight = instance.highlight;
            this.maxErrors = instance.maxErrors;
            this.realWordErrorLikelihood = instance.realWordErrorLikelihood;
            this.separator = instance.separator;
            this.shardSize = instance.shardSize;
            this.smoothing = instance.smoothing;
            this.text = instance.text;
            this.tokenLimit = instance.tokenLimit;
        }

        public final Builder collate(@Nullable PhraseSuggestCollate value) {
            this.collate = value;
            return this;
        }

        public final Builder collate(Function<PhraseSuggestCollate.Builder, ObjectBuilder<PhraseSuggestCollate>> fn) {
            return this.collate(fn.apply(new PhraseSuggestCollate.Builder()).build());
        }

        public final Builder confidence(@Nullable Double value) {
            this.confidence = value;
            return this;
        }

        public final Builder directGenerator(List<DirectGenerator> list) {
            this.directGenerator = Builder._listAddAll(this.directGenerator, list);
            return this;
        }

        public final Builder directGenerator(DirectGenerator value, DirectGenerator ... values) {
            this.directGenerator = Builder._listAdd(this.directGenerator, value, values);
            return this;
        }

        public final Builder directGenerator(Function<DirectGenerator.Builder, ObjectBuilder<DirectGenerator>> fn) {
            return this.directGenerator(fn.apply(new DirectGenerator.Builder()).build(), new DirectGenerator[0]);
        }

        public final Builder forceUnigrams(@Nullable Boolean value) {
            this.forceUnigrams = value;
            return this;
        }

        public final Builder gramSize(@Nullable Integer value) {
            this.gramSize = value;
            return this;
        }

        public final Builder highlight(@Nullable PhraseSuggestHighlight value) {
            this.highlight = value;
            return this;
        }

        public final Builder highlight(Function<PhraseSuggestHighlight.Builder, ObjectBuilder<PhraseSuggestHighlight>> fn) {
            return this.highlight(fn.apply(new PhraseSuggestHighlight.Builder()).build());
        }

        public final Builder maxErrors(@Nullable Double value) {
            this.maxErrors = value;
            return this;
        }

        public final Builder realWordErrorLikelihood(@Nullable Double value) {
            this.realWordErrorLikelihood = value;
            return this;
        }

        public final Builder separator(@Nullable String value) {
            this.separator = value;
            return this;
        }

        public final Builder shardSize(@Nullable Integer value) {
            this.shardSize = value;
            return this;
        }

        public final Builder smoothing(@Nullable SmoothingModel value) {
            this.smoothing = value;
            return this;
        }

        public final Builder smoothing(Function<SmoothingModel.Builder, ObjectBuilder<SmoothingModel>> fn) {
            return this.smoothing(fn.apply(new SmoothingModel.Builder()).build());
        }

        public final Builder smoothing(SmoothingModelVariant value) {
            this.smoothing = value._toSmoothingModel();
            return this;
        }

        public final Builder text(@Nullable String value) {
            this.text = value;
            return this;
        }

        public final Builder tokenLimit(@Nullable Integer value) {
            this.tokenLimit = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PhraseSuggester build() {
            this._checkSingleUse();
            return new PhraseSuggester(this);
        }
    }
}

