/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.HighlightBase;
import co.elastic.clients.elasticsearch.core.search.HighlightField;
import co.elastic.clients.elasticsearch.core.search.HighlighterEncoder;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Highlight
extends HighlightBase {
    @Nullable
    private final HighlighterEncoder encoder;
    private final Map<String, HighlightField> fields;
    public static final JsonpDeserializer<Highlight> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Highlight::setupHighlightDeserializer);

    private Highlight(Builder builder) {
        super(builder);
        this.encoder = builder.encoder;
        this.fields = ApiTypeHelper.unmodifiableRequired(builder.fields, (Object)this, "fields");
    }

    public static Highlight of(Function<Builder, ObjectBuilder<Highlight>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final HighlighterEncoder encoder() {
        return this.encoder;
    }

    public final Map<String, HighlightField> fields() {
        return this.fields;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.encoder != null) {
            generator.writeKey("encoder");
            this.encoder.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, HighlightField> item0 : this.fields.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupHighlightDeserializer(ObjectDeserializer<Builder> op) {
        HighlightBase.setupHighlightBaseDeserializer(op);
        op.add(Builder::encoder, HighlighterEncoder._DESERIALIZER, "encoder");
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(HighlightField._DESERIALIZER), "fields");
    }

    public static class Builder
    extends HighlightBase.AbstractBuilder<Builder>
    implements ObjectBuilder<Highlight> {
        @Nullable
        private HighlighterEncoder encoder;
        private Map<String, HighlightField> fields;

        public Builder() {
        }

        private Builder(Highlight instance) {
            this.encoder = instance.encoder;
            this.fields = instance.fields;
        }

        public final Builder encoder(@Nullable HighlighterEncoder value) {
            this.encoder = value;
            return this;
        }

        public final Builder fields(Map<String, HighlightField> map) {
            this.fields = Builder._mapPutAll(this.fields, map);
            return this;
        }

        public final Builder fields(String key, HighlightField value) {
            this.fields = Builder._mapPut(this.fields, key, value);
            return this;
        }

        public final Builder fields(String key, Function<HighlightField.Builder, ObjectBuilder<HighlightField>> fn) {
            return this.fields(key, fn.apply(new HighlightField.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Highlight build() {
            this._checkSingleUse();
            return new Highlight(this);
        }
    }
}

