/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.health_report;

import co.elastic.clients.elasticsearch.core.health_report.ImpactArea;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class Impact
implements JsonpSerializable {
    private final String description;
    private final String id;
    private final List<ImpactArea> impactAreas;
    private final int severity;
    public static final JsonpDeserializer<Impact> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Impact::setupImpactDeserializer);

    private Impact(Builder builder) {
        this.description = ApiTypeHelper.requireNonNull(builder.description, this, "description");
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.impactAreas = ApiTypeHelper.unmodifiableRequired(builder.impactAreas, (Object)this, "impactAreas");
        this.severity = ApiTypeHelper.requireNonNull(builder.severity, (Object)this, "severity", 0);
    }

    public static Impact of(Function<Builder, ObjectBuilder<Impact>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String description() {
        return this.description;
    }

    public final String id() {
        return this.id;
    }

    public final List<ImpactArea> impactAreas() {
        return this.impactAreas;
    }

    public final int severity() {
        return this.severity;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("description");
        generator.write(this.description);
        generator.writeKey("id");
        generator.write(this.id);
        if (ApiTypeHelper.isDefined(this.impactAreas)) {
            generator.writeKey("impact_areas");
            generator.writeStartArray();
            for (ImpactArea item0 : this.impactAreas) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("severity");
        generator.write(this.severity);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupImpactDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::impactAreas, JsonpDeserializer.arrayDeserializer(ImpactArea._DESERIALIZER), "impact_areas");
        op.add(Builder::severity, JsonpDeserializer.integerDeserializer(), "severity");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Impact> {
        private String description;
        private String id;
        private List<ImpactArea> impactAreas;
        private Integer severity;

        public Builder() {
        }

        private Builder(Impact instance) {
            this.description = instance.description;
            this.id = instance.id;
            this.impactAreas = instance.impactAreas;
            this.severity = instance.severity;
        }

        public final Builder description(String value) {
            this.description = value;
            return this;
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder impactAreas(List<ImpactArea> list) {
            this.impactAreas = Builder._listAddAll(this.impactAreas, list);
            return this;
        }

        public final Builder impactAreas(ImpactArea value, ImpactArea ... values) {
            this.impactAreas = Builder._listAdd(this.impactAreas, value, values);
            return this;
        }

        public final Builder severity(int value) {
            this.severity = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Impact build() {
            this._checkSingleUse();
            return new Impact(this);
        }
    }
}

