/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.health_report;

import co.elastic.clients.elasticsearch.core.health_report.IndicatorNode;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DiagnosisAffectedResources
implements JsonpSerializable {
    private final List<String> indices;
    private final List<IndicatorNode> nodes;
    private final List<String> slmPolicies;
    private final List<String> featureStates;
    private final List<String> snapshotRepositories;
    public static final JsonpDeserializer<DiagnosisAffectedResources> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DiagnosisAffectedResources::setupDiagnosisAffectedResourcesDeserializer);

    private DiagnosisAffectedResources(Builder builder) {
        this.indices = ApiTypeHelper.unmodifiable(builder.indices);
        this.nodes = ApiTypeHelper.unmodifiable(builder.nodes);
        this.slmPolicies = ApiTypeHelper.unmodifiable(builder.slmPolicies);
        this.featureStates = ApiTypeHelper.unmodifiable(builder.featureStates);
        this.snapshotRepositories = ApiTypeHelper.unmodifiable(builder.snapshotRepositories);
    }

    public static DiagnosisAffectedResources of(Function<Builder, ObjectBuilder<DiagnosisAffectedResources>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> indices() {
        return this.indices;
    }

    public final List<IndicatorNode> nodes() {
        return this.nodes;
    }

    public final List<String> slmPolicies() {
        return this.slmPolicies;
    }

    public final List<String> featureStates() {
        return this.featureStates;
    }

    public final List<String> snapshotRepositories() {
        return this.snapshotRepositories;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String string : this.indices) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.nodes)) {
            generator.writeKey("nodes");
            generator.writeStartArray();
            for (IndicatorNode indicatorNode : this.nodes) {
                indicatorNode.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.slmPolicies)) {
            generator.writeKey("slm_policies");
            generator.writeStartArray();
            for (String string : this.slmPolicies) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.featureStates)) {
            generator.writeKey("feature_states");
            generator.writeStartArray();
            for (String string : this.featureStates) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.snapshotRepositories)) {
            generator.writeKey("snapshot_repositories");
            generator.writeStartArray();
            for (String string : this.snapshotRepositories) {
                generator.write(string);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDiagnosisAffectedResourcesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices");
        op.add(Builder::nodes, JsonpDeserializer.arrayDeserializer(IndicatorNode._DESERIALIZER), "nodes");
        op.add(Builder::slmPolicies, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "slm_policies");
        op.add(Builder::featureStates, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "feature_states");
        op.add(Builder::snapshotRepositories, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "snapshot_repositories");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DiagnosisAffectedResources> {
        @Nullable
        private List<String> indices;
        @Nullable
        private List<IndicatorNode> nodes;
        @Nullable
        private List<String> slmPolicies;
        @Nullable
        private List<String> featureStates;
        @Nullable
        private List<String> snapshotRepositories;

        public Builder() {
        }

        private Builder(DiagnosisAffectedResources instance) {
            this.indices = instance.indices;
            this.nodes = instance.nodes;
            this.slmPolicies = instance.slmPolicies;
            this.featureStates = instance.featureStates;
            this.snapshotRepositories = instance.snapshotRepositories;
        }

        public final Builder indices(List<String> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(String value, String ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder nodes(List<IndicatorNode> list) {
            this.nodes = Builder._listAddAll(this.nodes, list);
            return this;
        }

        public final Builder nodes(IndicatorNode value, IndicatorNode ... values) {
            this.nodes = Builder._listAdd(this.nodes, value, values);
            return this;
        }

        public final Builder nodes(Function<IndicatorNode.Builder, ObjectBuilder<IndicatorNode>> fn) {
            return this.nodes(fn.apply(new IndicatorNode.Builder()).build(), new IndicatorNode[0]);
        }

        public final Builder slmPolicies(List<String> list) {
            this.slmPolicies = Builder._listAddAll(this.slmPolicies, list);
            return this;
        }

        public final Builder slmPolicies(String value, String ... values) {
            this.slmPolicies = Builder._listAdd(this.slmPolicies, value, values);
            return this;
        }

        public final Builder featureStates(List<String> list) {
            this.featureStates = Builder._listAddAll(this.featureStates, list);
            return this;
        }

        public final Builder featureStates(String value, String ... values) {
            this.featureStates = Builder._listAdd(this.featureStates, value, values);
            return this;
        }

        public final Builder snapshotRepositories(List<String> list) {
            this.snapshotRepositories = Builder._listAddAll(this.snapshotRepositories, list);
            return this;
        }

        public final Builder snapshotRepositories(String value, String ... values) {
            this.snapshotRepositories = Builder._listAdd(this.snapshotRepositories, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DiagnosisAffectedResources build() {
            this._checkSingleUse();
            return new DiagnosisAffectedResources(this);
        }
    }
}

