/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.connector.ConnectorStatus;
import co.elastic.clients.elasticsearch.connector.UpdateStatusResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;

@JsonpDeserializable
public class UpdateStatusRequest
extends RequestBase
implements JsonpSerializable {
    private final String connectorId;
    private final ConnectorStatus status;
    public static final JsonpDeserializer<UpdateStatusRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateStatusRequest::setupUpdateStatusRequestDeserializer);
    public static final Endpoint<UpdateStatusRequest, UpdateStatusResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateStatusRequest, UpdateStatusResponse>("es/connector.update_status", request -> "PUT", request -> {
        boolean _connectorId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_connector");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.connectorId, buf);
            buf.append("/_status");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _connectorId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("connectorId", request.connectorId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, UpdateStatusResponse._DESERIALIZER);

    private UpdateStatusRequest(Builder builder) {
        this.connectorId = ApiTypeHelper.requireNonNull(builder.connectorId, this, "connectorId");
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
    }

    public static UpdateStatusRequest of(Function<Builder, ObjectBuilder<UpdateStatusRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String connectorId() {
        return this.connectorId;
    }

    public final ConnectorStatus status() {
        return this.status;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupUpdateStatusRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::status, ConnectorStatus._DESERIALIZER, "status");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UpdateStatusRequest> {
        private String connectorId;
        private ConnectorStatus status;

        public Builder() {
        }

        private Builder(UpdateStatusRequest instance) {
            this.connectorId = instance.connectorId;
            this.status = instance.status;
        }

        public final Builder connectorId(String value) {
            this.connectorId = value;
            return this;
        }

        public final Builder status(ConnectorStatus value) {
            this.status = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdateStatusRequest build() {
            this._checkSingleUse();
            return new UpdateStatusRequest(this);
        }
    }
}

