/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.connector.FilteringAdvancedSnippet;
import co.elastic.clients.elasticsearch.connector.FilteringConfig;
import co.elastic.clients.elasticsearch.connector.FilteringRule;
import co.elastic.clients.elasticsearch.connector.UpdateFilteringResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UpdateFilteringRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final FilteringAdvancedSnippet advancedSnippet;
    private final String connectorId;
    private final List<FilteringConfig> filtering;
    private final List<FilteringRule> rules;
    public static final JsonpDeserializer<UpdateFilteringRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateFilteringRequest::setupUpdateFilteringRequestDeserializer);
    public static final Endpoint<UpdateFilteringRequest, UpdateFilteringResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateFilteringRequest, UpdateFilteringResponse>("es/connector.update_filtering", request -> "PUT", request -> {
        boolean _connectorId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_connector");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.connectorId, buf);
            buf.append("/_filtering");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _connectorId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("connectorId", request.connectorId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, UpdateFilteringResponse._DESERIALIZER);

    private UpdateFilteringRequest(Builder builder) {
        this.advancedSnippet = builder.advancedSnippet;
        this.connectorId = ApiTypeHelper.requireNonNull(builder.connectorId, this, "connectorId");
        this.filtering = ApiTypeHelper.unmodifiable(builder.filtering);
        this.rules = ApiTypeHelper.unmodifiable(builder.rules);
    }

    public static UpdateFilteringRequest of(Function<Builder, ObjectBuilder<UpdateFilteringRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final FilteringAdvancedSnippet advancedSnippet() {
        return this.advancedSnippet;
    }

    public final String connectorId() {
        return this.connectorId;
    }

    public final List<FilteringConfig> filtering() {
        return this.filtering;
    }

    public final List<FilteringRule> rules() {
        return this.rules;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.advancedSnippet != null) {
            generator.writeKey("advanced_snippet");
            this.advancedSnippet.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.filtering)) {
            generator.writeKey("filtering");
            generator.writeStartArray();
            for (FilteringConfig filteringConfig : this.filtering) {
                filteringConfig.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.rules)) {
            generator.writeKey("rules");
            generator.writeStartArray();
            for (FilteringRule filteringRule : this.rules) {
                filteringRule.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupUpdateFilteringRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::advancedSnippet, FilteringAdvancedSnippet._DESERIALIZER, "advanced_snippet");
        op.add(Builder::filtering, JsonpDeserializer.arrayDeserializer(FilteringConfig._DESERIALIZER), "filtering");
        op.add(Builder::rules, JsonpDeserializer.arrayDeserializer(FilteringRule._DESERIALIZER), "rules");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UpdateFilteringRequest> {
        @Nullable
        private FilteringAdvancedSnippet advancedSnippet;
        private String connectorId;
        @Nullable
        private List<FilteringConfig> filtering;
        @Nullable
        private List<FilteringRule> rules;

        public Builder() {
        }

        private Builder(UpdateFilteringRequest instance) {
            this.advancedSnippet = instance.advancedSnippet;
            this.connectorId = instance.connectorId;
            this.filtering = instance.filtering;
            this.rules = instance.rules;
        }

        public final Builder advancedSnippet(@Nullable FilteringAdvancedSnippet value) {
            this.advancedSnippet = value;
            return this;
        }

        public final Builder advancedSnippet(Function<FilteringAdvancedSnippet.Builder, ObjectBuilder<FilteringAdvancedSnippet>> fn) {
            return this.advancedSnippet(fn.apply(new FilteringAdvancedSnippet.Builder()).build());
        }

        public final Builder connectorId(String value) {
            this.connectorId = value;
            return this;
        }

        public final Builder filtering(List<FilteringConfig> list) {
            this.filtering = Builder._listAddAll(this.filtering, list);
            return this;
        }

        public final Builder filtering(FilteringConfig value, FilteringConfig ... values) {
            this.filtering = Builder._listAdd(this.filtering, value, values);
            return this;
        }

        public final Builder filtering(Function<FilteringConfig.Builder, ObjectBuilder<FilteringConfig>> fn) {
            return this.filtering(fn.apply(new FilteringConfig.Builder()).build(), new FilteringConfig[0]);
        }

        public final Builder rules(List<FilteringRule> list) {
            this.rules = Builder._listAddAll(this.rules, list);
            return this;
        }

        public final Builder rules(FilteringRule value, FilteringRule ... values) {
            this.rules = Builder._listAdd(this.rules, value, values);
            return this;
        }

        public final Builder rules(Function<FilteringRule.Builder, ObjectBuilder<FilteringRule>> fn) {
            return this.rules(fn.apply(new FilteringRule.Builder()).build(), new FilteringRule[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdateFilteringRequest build() {
            this._checkSingleUse();
            return new UpdateFilteringRequest(this);
        }
    }
}

