/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.connector.PutResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String connectorId;
    @Nullable
    private final String description;
    @Nullable
    private final String indexName;
    @Nullable
    private final Boolean isNative;
    @Nullable
    private final String language;
    @Nullable
    private final String name;
    @Nullable
    private final String serviceType;
    public static final JsonpDeserializer<PutRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutRequest::setupPutRequestDeserializer);
    public static final Endpoint<PutRequest, PutResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutRequest, PutResponse>("es/connector.put", request -> "PUT", request -> {
        boolean _connectorId = true;
        boolean propsSet = false;
        if (request.connectorId() != null) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_connector");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.connectorId, buf);
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_connector");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _connectorId = true;
        boolean propsSet = false;
        if (request.connectorId() != null) {
            propsSet |= true;
        }
        if (propsSet) {
            params.put("connectorId", request.connectorId);
        }
        if (!propsSet) {
            // empty if block
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutResponse._DESERIALIZER);

    private PutRequest(Builder builder) {
        this.connectorId = builder.connectorId;
        this.description = builder.description;
        this.indexName = builder.indexName;
        this.isNative = builder.isNative;
        this.language = builder.language;
        this.name = builder.name;
        this.serviceType = builder.serviceType;
    }

    public static PutRequest of(Function<Builder, ObjectBuilder<PutRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String connectorId() {
        return this.connectorId;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final String indexName() {
        return this.indexName;
    }

    @Nullable
    public final Boolean isNative() {
        return this.isNative;
    }

    @Nullable
    public final String language() {
        return this.language;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    @Nullable
    public final String serviceType() {
        return this.serviceType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.indexName != null) {
            generator.writeKey("index_name");
            generator.write(this.indexName);
        }
        if (this.isNative != null) {
            generator.writeKey("is_native");
            generator.write(this.isNative.booleanValue());
        }
        if (this.language != null) {
            generator.writeKey("language");
            generator.write(this.language);
        }
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        if (this.serviceType != null) {
            generator.writeKey("service_type");
            generator.write(this.serviceType);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPutRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::indexName, JsonpDeserializer.stringDeserializer(), "index_name");
        op.add(Builder::isNative, JsonpDeserializer.booleanDeserializer(), "is_native");
        op.add(Builder::language, JsonpDeserializer.stringDeserializer(), "language");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::serviceType, JsonpDeserializer.stringDeserializer(), "service_type");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutRequest> {
        @Nullable
        private String connectorId;
        @Nullable
        private String description;
        @Nullable
        private String indexName;
        @Nullable
        private Boolean isNative;
        @Nullable
        private String language;
        @Nullable
        private String name;
        @Nullable
        private String serviceType;

        public Builder() {
        }

        private Builder(PutRequest instance) {
            this.connectorId = instance.connectorId;
            this.description = instance.description;
            this.indexName = instance.indexName;
            this.isNative = instance.isNative;
            this.language = instance.language;
            this.name = instance.name;
            this.serviceType = instance.serviceType;
        }

        public final Builder connectorId(@Nullable String value) {
            this.connectorId = value;
            return this;
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder indexName(@Nullable String value) {
            this.indexName = value;
            return this;
        }

        public final Builder isNative(@Nullable Boolean value) {
            this.isNative = value;
            return this;
        }

        public final Builder language(@Nullable String value) {
            this.language = value;
            return this;
        }

        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        public final Builder serviceType(@Nullable String value) {
            this.serviceType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutRequest build() {
            this._checkSingleUse();
            return new PutRequest(this);
        }
    }
}

