/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch.connector.Validation;
import co.elastic.clients.elasticsearch.connector.ValidationVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class IncludedInValidation
implements ValidationVariant,
JsonpSerializable {
    private final List<FieldValue> constraint;
    public static final JsonpDeserializer<IncludedInValidation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IncludedInValidation::setupIncludedInValidationDeserializer);

    private IncludedInValidation(Builder builder) {
        this.constraint = ApiTypeHelper.unmodifiableRequired(builder.constraint, (Object)this, "constraint");
    }

    public static IncludedInValidation of(Function<Builder, ObjectBuilder<IncludedInValidation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Validation.Kind _validationKind() {
        return Validation.Kind.IncludedIn;
    }

    public final List<FieldValue> constraint() {
        return this.constraint;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "included_in");
        if (ApiTypeHelper.isDefined(this.constraint)) {
            generator.writeKey("constraint");
            generator.writeStartArray();
            for (FieldValue item0 : this.constraint) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupIncludedInValidationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::constraint, JsonpDeserializer.arrayDeserializer(FieldValue._DESERIALIZER), "constraint");
        op.ignore("type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IncludedInValidation> {
        private List<FieldValue> constraint;

        public Builder() {
        }

        private Builder(IncludedInValidation instance) {
            this.constraint = instance.constraint;
        }

        public final Builder constraint(List<FieldValue> list) {
            this.constraint = Builder._listAddAll(this.constraint, list);
            return this;
        }

        public final Builder constraint(FieldValue value, FieldValue ... values) {
            this.constraint = Builder._listAdd(this.constraint, value, values);
            return this;
        }

        public final Builder constraint(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.constraint(fn.apply(new FieldValue.Builder()).build(), new FieldValue[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IncludedInValidation build() {
            this._checkSingleUse();
            return new IncludedInValidation(this);
        }
    }
}

