/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class SynonymsStats
implements JsonpSerializable {
    private final int count;
    private final int indexCount;
    public static final JsonpDeserializer<SynonymsStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SynonymsStats::setupSynonymsStatsDeserializer);

    private SynonymsStats(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0);
        this.indexCount = ApiTypeHelper.requireNonNull(builder.indexCount, (Object)this, "indexCount", 0);
    }

    public static SynonymsStats of(Function<Builder, ObjectBuilder<SynonymsStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int count() {
        return this.count;
    }

    public final int indexCount() {
        return this.indexCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("index_count");
        generator.write(this.indexCount);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSynonymsStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
        op.add(Builder::indexCount, JsonpDeserializer.integerDeserializer(), "index_count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SynonymsStats> {
        private Integer count;
        private Integer indexCount;

        public Builder() {
        }

        private Builder(SynonymsStats instance) {
            this.count = instance.count;
            this.indexCount = instance.indexCount;
        }

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        public final Builder indexCount(int value) {
            this.indexCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SynonymsStats build() {
            this._checkSingleUse();
            return new SynonymsStats(this);
        }
    }
}

