/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.remote_info;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.cluster.remote_info.ClusterRemoteInfo;
import co.elastic.clients.elasticsearch.cluster.remote_info.ClusterRemoteInfoVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class ClusterRemoteSniffInfo
implements ClusterRemoteInfoVariant,
JsonpSerializable {
    private final boolean connected;
    private final int maxConnectionsPerCluster;
    private final long numNodesConnected;
    private final Time initialConnectTimeout;
    private final boolean skipUnavailable;
    private final List<String> seeds;
    public static final JsonpDeserializer<ClusterRemoteSniffInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterRemoteSniffInfo::setupClusterRemoteSniffInfoDeserializer);

    private ClusterRemoteSniffInfo(Builder builder) {
        this.connected = ApiTypeHelper.requireNonNull(builder.connected, (Object)this, "connected", false);
        this.maxConnectionsPerCluster = ApiTypeHelper.requireNonNull(builder.maxConnectionsPerCluster, (Object)this, "maxConnectionsPerCluster", 0);
        this.numNodesConnected = ApiTypeHelper.requireNonNull(builder.numNodesConnected, (Object)this, "numNodesConnected", 0L);
        this.initialConnectTimeout = ApiTypeHelper.requireNonNull(builder.initialConnectTimeout, this, "initialConnectTimeout");
        this.skipUnavailable = ApiTypeHelper.requireNonNull(builder.skipUnavailable, (Object)this, "skipUnavailable", false);
        this.seeds = ApiTypeHelper.unmodifiableRequired(builder.seeds, (Object)this, "seeds");
    }

    public static ClusterRemoteSniffInfo of(Function<Builder, ObjectBuilder<ClusterRemoteSniffInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public ClusterRemoteInfo.Kind _clusterRemoteInfoKind() {
        return ClusterRemoteInfo.Kind.Sniff;
    }

    public final boolean connected() {
        return this.connected;
    }

    public final int maxConnectionsPerCluster() {
        return this.maxConnectionsPerCluster;
    }

    public final long numNodesConnected() {
        return this.numNodesConnected;
    }

    public final Time initialConnectTimeout() {
        return this.initialConnectTimeout;
    }

    public final boolean skipUnavailable() {
        return this.skipUnavailable;
    }

    public final List<String> seeds() {
        return this.seeds;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("mode", "sniff");
        generator.writeKey("connected");
        generator.write(this.connected);
        generator.writeKey("max_connections_per_cluster");
        generator.write(this.maxConnectionsPerCluster);
        generator.writeKey("num_nodes_connected");
        generator.write(this.numNodesConnected);
        generator.writeKey("initial_connect_timeout");
        this.initialConnectTimeout.serialize(generator, mapper);
        generator.writeKey("skip_unavailable");
        generator.write(this.skipUnavailable);
        if (ApiTypeHelper.isDefined(this.seeds)) {
            generator.writeKey("seeds");
            generator.writeStartArray();
            for (String item0 : this.seeds) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupClusterRemoteSniffInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::connected, JsonpDeserializer.booleanDeserializer(), "connected");
        op.add(Builder::maxConnectionsPerCluster, JsonpDeserializer.integerDeserializer(), "max_connections_per_cluster");
        op.add(Builder::numNodesConnected, JsonpDeserializer.longDeserializer(), "num_nodes_connected");
        op.add(Builder::initialConnectTimeout, Time._DESERIALIZER, "initial_connect_timeout");
        op.add(Builder::skipUnavailable, JsonpDeserializer.booleanDeserializer(), "skip_unavailable");
        op.add(Builder::seeds, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "seeds");
        op.ignore("mode");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ClusterRemoteSniffInfo> {
        private Boolean connected;
        private Integer maxConnectionsPerCluster;
        private Long numNodesConnected;
        private Time initialConnectTimeout;
        private Boolean skipUnavailable;
        private List<String> seeds;

        public Builder() {
        }

        private Builder(ClusterRemoteSniffInfo instance) {
            this.connected = instance.connected;
            this.maxConnectionsPerCluster = instance.maxConnectionsPerCluster;
            this.numNodesConnected = instance.numNodesConnected;
            this.initialConnectTimeout = instance.initialConnectTimeout;
            this.skipUnavailable = instance.skipUnavailable;
            this.seeds = instance.seeds;
        }

        public final Builder connected(boolean value) {
            this.connected = value;
            return this;
        }

        public final Builder maxConnectionsPerCluster(int value) {
            this.maxConnectionsPerCluster = value;
            return this;
        }

        public final Builder numNodesConnected(long value) {
            this.numNodesConnected = value;
            return this;
        }

        public final Builder initialConnectTimeout(Time value) {
            this.initialConnectTimeout = value;
            return this;
        }

        public final Builder initialConnectTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.initialConnectTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder skipUnavailable(boolean value) {
            this.skipUnavailable = value;
            return this;
        }

        public final Builder seeds(List<String> list) {
            this.seeds = Builder._listAddAll(this.seeds, list);
            return this;
        }

        public final Builder seeds(String value, String ... values) {
            this.seeds = Builder._listAdd(this.seeds, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ClusterRemoteSniffInfo build() {
            this._checkSingleUse();
            return new ClusterRemoteSniffInfo(this);
        }
    }
}

