/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.remote_info;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.cluster.remote_info.ClusterRemoteInfo;
import co.elastic.clients.elasticsearch.cluster.remote_info.ClusterRemoteInfoVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ClusterRemoteProxyInfo
implements ClusterRemoteInfoVariant,
JsonpSerializable {
    private final boolean connected;
    private final Time initialConnectTimeout;
    private final boolean skipUnavailable;
    private final String proxyAddress;
    private final String serverName;
    private final int numProxySocketsConnected;
    private final int maxProxySocketConnections;
    @Nullable
    private final String clusterCredentials;
    public static final JsonpDeserializer<ClusterRemoteProxyInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterRemoteProxyInfo::setupClusterRemoteProxyInfoDeserializer);

    private ClusterRemoteProxyInfo(Builder builder) {
        this.connected = ApiTypeHelper.requireNonNull(builder.connected, (Object)this, "connected", false);
        this.initialConnectTimeout = ApiTypeHelper.requireNonNull(builder.initialConnectTimeout, this, "initialConnectTimeout");
        this.skipUnavailable = ApiTypeHelper.requireNonNull(builder.skipUnavailable, (Object)this, "skipUnavailable", false);
        this.proxyAddress = ApiTypeHelper.requireNonNull(builder.proxyAddress, this, "proxyAddress");
        this.serverName = ApiTypeHelper.requireNonNull(builder.serverName, this, "serverName");
        this.numProxySocketsConnected = ApiTypeHelper.requireNonNull(builder.numProxySocketsConnected, (Object)this, "numProxySocketsConnected", 0);
        this.maxProxySocketConnections = ApiTypeHelper.requireNonNull(builder.maxProxySocketConnections, (Object)this, "maxProxySocketConnections", 0);
        this.clusterCredentials = builder.clusterCredentials;
    }

    public static ClusterRemoteProxyInfo of(Function<Builder, ObjectBuilder<ClusterRemoteProxyInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public ClusterRemoteInfo.Kind _clusterRemoteInfoKind() {
        return ClusterRemoteInfo.Kind.Proxy;
    }

    public final boolean connected() {
        return this.connected;
    }

    public final Time initialConnectTimeout() {
        return this.initialConnectTimeout;
    }

    public final boolean skipUnavailable() {
        return this.skipUnavailable;
    }

    public final String proxyAddress() {
        return this.proxyAddress;
    }

    public final String serverName() {
        return this.serverName;
    }

    public final int numProxySocketsConnected() {
        return this.numProxySocketsConnected;
    }

    public final int maxProxySocketConnections() {
        return this.maxProxySocketConnections;
    }

    @Nullable
    public final String clusterCredentials() {
        return this.clusterCredentials;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("mode", "proxy");
        generator.writeKey("connected");
        generator.write(this.connected);
        generator.writeKey("initial_connect_timeout");
        this.initialConnectTimeout.serialize(generator, mapper);
        generator.writeKey("skip_unavailable");
        generator.write(this.skipUnavailable);
        generator.writeKey("proxy_address");
        generator.write(this.proxyAddress);
        generator.writeKey("server_name");
        generator.write(this.serverName);
        generator.writeKey("num_proxy_sockets_connected");
        generator.write(this.numProxySocketsConnected);
        generator.writeKey("max_proxy_socket_connections");
        generator.write(this.maxProxySocketConnections);
        if (this.clusterCredentials != null) {
            generator.writeKey("cluster_credentials");
            generator.write(this.clusterCredentials);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupClusterRemoteProxyInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::connected, JsonpDeserializer.booleanDeserializer(), "connected");
        op.add(Builder::initialConnectTimeout, Time._DESERIALIZER, "initial_connect_timeout");
        op.add(Builder::skipUnavailable, JsonpDeserializer.booleanDeserializer(), "skip_unavailable");
        op.add(Builder::proxyAddress, JsonpDeserializer.stringDeserializer(), "proxy_address");
        op.add(Builder::serverName, JsonpDeserializer.stringDeserializer(), "server_name");
        op.add(Builder::numProxySocketsConnected, JsonpDeserializer.integerDeserializer(), "num_proxy_sockets_connected");
        op.add(Builder::maxProxySocketConnections, JsonpDeserializer.integerDeserializer(), "max_proxy_socket_connections");
        op.add(Builder::clusterCredentials, JsonpDeserializer.stringDeserializer(), "cluster_credentials");
        op.ignore("mode");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ClusterRemoteProxyInfo> {
        private Boolean connected;
        private Time initialConnectTimeout;
        private Boolean skipUnavailable;
        private String proxyAddress;
        private String serverName;
        private Integer numProxySocketsConnected;
        private Integer maxProxySocketConnections;
        @Nullable
        private String clusterCredentials;

        public Builder() {
        }

        private Builder(ClusterRemoteProxyInfo instance) {
            this.connected = instance.connected;
            this.initialConnectTimeout = instance.initialConnectTimeout;
            this.skipUnavailable = instance.skipUnavailable;
            this.proxyAddress = instance.proxyAddress;
            this.serverName = instance.serverName;
            this.numProxySocketsConnected = instance.numProxySocketsConnected;
            this.maxProxySocketConnections = instance.maxProxySocketConnections;
            this.clusterCredentials = instance.clusterCredentials;
        }

        public final Builder connected(boolean value) {
            this.connected = value;
            return this;
        }

        public final Builder initialConnectTimeout(Time value) {
            this.initialConnectTimeout = value;
            return this;
        }

        public final Builder initialConnectTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.initialConnectTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder skipUnavailable(boolean value) {
            this.skipUnavailable = value;
            return this;
        }

        public final Builder proxyAddress(String value) {
            this.proxyAddress = value;
            return this;
        }

        public final Builder serverName(String value) {
            this.serverName = value;
            return this;
        }

        public final Builder numProxySocketsConnected(int value) {
            this.numProxySocketsConnected = value;
            return this;
        }

        public final Builder maxProxySocketConnections(int value) {
            this.maxProxySocketConnections = value;
            return this;
        }

        public final Builder clusterCredentials(@Nullable String value) {
            this.clusterCredentials = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ClusterRemoteProxyInfo build() {
            this._checkSingleUse();
            return new ClusterRemoteProxyInfo(this);
        }
    }
}

