/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ccr.GetAutoFollowPatternResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class GetAutoFollowPatternRequest
extends RequestBase {
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final String name;
    public static final Endpoint<GetAutoFollowPatternRequest, GetAutoFollowPatternResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetAutoFollowPatternRequest, GetAutoFollowPatternResponse>("es/ccr.get_auto_follow_pattern", request -> "GET", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (request.name() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ccr");
            buf.append("/auto_follow");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ccr");
            buf.append("/auto_follow");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _name = true;
        boolean propsSet = false;
        if (request.name() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            // empty if block
        }
        if (propsSet) {
            params.put("name", request.name);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetAutoFollowPatternResponse._DESERIALIZER);

    private GetAutoFollowPatternRequest(Builder builder) {
        this.masterTimeout = builder.masterTimeout;
        this.name = builder.name;
    }

    public static GetAutoFollowPatternRequest of(Function<Builder, ObjectBuilder<GetAutoFollowPatternRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetAutoFollowPatternRequest> {
        @Nullable
        private Time masterTimeout;
        @Nullable
        private String name;

        public Builder() {
        }

        private Builder(GetAutoFollowPatternRequest instance) {
            this.masterTimeout = instance.masterTimeout;
            this.name = instance.name;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetAutoFollowPatternRequest build() {
            this._checkSingleUse();
            return new GetAutoFollowPatternRequest(this);
        }
    }
}

