/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch._types.Bytes;
import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.TimeUnit;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.HealthResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class HealthRequest
extends CatRequestBase {
    @Nullable
    private final Bytes bytes;
    private final List<String> h;
    private final List<String> s;
    @Nullable
    private final TimeUnit time;
    @Nullable
    private final Boolean ts;
    public static final Endpoint<HealthRequest, HealthResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<HealthRequest, HealthResponse>("es/cat.health", request -> "GET", request -> "/_cat/health", request -> Collections.emptyMap(), request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (ApiTypeHelper.isDefined(request.s)) {
            params.put("s", request.s.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.bytes != null) {
            params.put("bytes", request.bytes.jsonValue());
        }
        if (ApiTypeHelper.isDefined(request.h)) {
            params.put("h", request.h.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.time != null) {
            params.put("time", request.time.jsonValue());
        }
        if (request.ts != null) {
            params.put("ts", String.valueOf(request.ts));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, HealthResponse._DESERIALIZER);

    private HealthRequest(Builder builder) {
        this.bytes = builder.bytes;
        this.h = ApiTypeHelper.unmodifiable(builder.h);
        this.s = ApiTypeHelper.unmodifiable(builder.s);
        this.time = builder.time;
        this.ts = builder.ts;
    }

    public static HealthRequest of(Function<Builder, ObjectBuilder<HealthRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Bytes bytes() {
        return this.bytes;
    }

    public final List<String> h() {
        return this.h;
    }

    public final List<String> s() {
        return this.s;
    }

    @Nullable
    public final TimeUnit time() {
        return this.time;
    }

    @Nullable
    public final Boolean ts() {
        return this.ts;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends CatRequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<HealthRequest> {
        @Nullable
        private Bytes bytes;
        @Nullable
        private List<String> h;
        @Nullable
        private List<String> s;
        @Nullable
        private TimeUnit time;
        @Nullable
        private Boolean ts;

        public Builder() {
        }

        private Builder(HealthRequest instance) {
            this.bytes = instance.bytes;
            this.h = instance.h;
            this.s = instance.s;
            this.time = instance.time;
            this.ts = instance.ts;
        }

        public final Builder bytes(@Nullable Bytes value) {
            this.bytes = value;
            return this;
        }

        public final Builder h(List<String> list) {
            this.h = Builder._listAddAll(this.h, list);
            return this;
        }

        public final Builder h(String value, String ... values) {
            this.h = Builder._listAdd(this.h, value, values);
            return this;
        }

        public final Builder s(List<String> list) {
            this.s = Builder._listAddAll(this.s, list);
            return this;
        }

        public final Builder s(String value, String ... values) {
            this.s = Builder._listAdd(this.s, value, values);
            return this;
        }

        public final Builder time(@Nullable TimeUnit value) {
            this.time = value;
            return this;
        }

        public final Builder ts(@Nullable Boolean value) {
            this.ts = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HealthRequest build() {
            this._checkSingleUse();
            return new HealthRequest(this);
        }
    }
}

