/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Operator;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.SimpleQueryStringFlag;
import co.elastic.clients.elasticsearch.security.query_api_keys.ApiKeyQuery;
import co.elastic.clients.elasticsearch.security.query_api_keys.ApiKeyQueryVariant;
import co.elastic.clients.elasticsearch.security.query_role.RoleQuery;
import co.elastic.clients.elasticsearch.security.query_role.RoleQueryVariant;
import co.elastic.clients.elasticsearch.security.query_user.UserQuery;
import co.elastic.clients.elasticsearch.security.query_user.UserQueryVariant;
import co.elastic.clients.json.JsonEnums;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SimpleQueryStringQuery
extends QueryBase
implements ApiKeyQueryVariant,
QueryVariant,
RoleQueryVariant,
UserQueryVariant {
    @Nullable
    private final String analyzer;
    @Nullable
    private final Boolean analyzeWildcard;
    @Nullable
    private final Boolean autoGenerateSynonymsPhraseQuery;
    @Nullable
    private final Operator defaultOperator;
    private final List<String> fields;
    private final List<SimpleQueryStringFlag> flags;
    @Nullable
    private final Integer fuzzyMaxExpansions;
    @Nullable
    private final Integer fuzzyPrefixLength;
    @Nullable
    private final Boolean fuzzyTranspositions;
    @Nullable
    private final Boolean lenient;
    @Nullable
    private final String minimumShouldMatch;
    private final String query;
    @Nullable
    private final String quoteFieldSuffix;
    public static final JsonpDeserializer<SimpleQueryStringQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SimpleQueryStringQuery::setupSimpleQueryStringQueryDeserializer);

    private SimpleQueryStringQuery(Builder builder) {
        super(builder);
        this.analyzer = builder.analyzer;
        this.analyzeWildcard = builder.analyzeWildcard;
        this.autoGenerateSynonymsPhraseQuery = builder.autoGenerateSynonymsPhraseQuery;
        this.defaultOperator = builder.defaultOperator;
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.flags = ApiTypeHelper.unmodifiable(builder.flags);
        this.fuzzyMaxExpansions = builder.fuzzyMaxExpansions;
        this.fuzzyPrefixLength = builder.fuzzyPrefixLength;
        this.fuzzyTranspositions = builder.fuzzyTranspositions;
        this.lenient = builder.lenient;
        this.minimumShouldMatch = builder.minimumShouldMatch;
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
        this.quoteFieldSuffix = builder.quoteFieldSuffix;
    }

    public static SimpleQueryStringQuery of(Function<Builder, ObjectBuilder<SimpleQueryStringQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public ApiKeyQuery.Kind _apiKeyQueryKind() {
        return ApiKeyQuery.Kind.SimpleQueryString;
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.SimpleQueryString;
    }

    @Override
    public RoleQuery.Kind _roleQueryKind() {
        return RoleQuery.Kind.SimpleQueryString;
    }

    @Override
    public UserQuery.Kind _userQueryKind() {
        return UserQuery.Kind.SimpleQueryString;
    }

    @Nullable
    public final String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public final Boolean analyzeWildcard() {
        return this.analyzeWildcard;
    }

    @Nullable
    public final Boolean autoGenerateSynonymsPhraseQuery() {
        return this.autoGenerateSynonymsPhraseQuery;
    }

    @Nullable
    public final Operator defaultOperator() {
        return this.defaultOperator;
    }

    public final List<String> fields() {
        return this.fields;
    }

    public final List<SimpleQueryStringFlag> flags() {
        return this.flags;
    }

    @Nullable
    public final Integer fuzzyMaxExpansions() {
        return this.fuzzyMaxExpansions;
    }

    @Nullable
    public final Integer fuzzyPrefixLength() {
        return this.fuzzyPrefixLength;
    }

    @Nullable
    public final Boolean fuzzyTranspositions() {
        return this.fuzzyTranspositions;
    }

    @Nullable
    public final Boolean lenient() {
        return this.lenient;
    }

    @Nullable
    public final String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    public final String query() {
        return this.query;
    }

    @Nullable
    public final String quoteFieldSuffix() {
        return this.quoteFieldSuffix;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (this.analyzeWildcard != null) {
            generator.writeKey("analyze_wildcard");
            generator.write(this.analyzeWildcard.booleanValue());
        }
        if (this.autoGenerateSynonymsPhraseQuery != null) {
            generator.writeKey("auto_generate_synonyms_phrase_query");
            generator.write(this.autoGenerateSynonymsPhraseQuery.booleanValue());
        }
        if (this.defaultOperator != null) {
            generator.writeKey("default_operator");
            this.defaultOperator.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (String item0 : this.fields) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.flags)) {
            generator.writeKey("flags");
            JsonEnums.serializePipeSeparated(this.flags, generator);
        }
        if (this.fuzzyMaxExpansions != null) {
            generator.writeKey("fuzzy_max_expansions");
            generator.write(this.fuzzyMaxExpansions.intValue());
        }
        if (this.fuzzyPrefixLength != null) {
            generator.writeKey("fuzzy_prefix_length");
            generator.write(this.fuzzyPrefixLength.intValue());
        }
        if (this.fuzzyTranspositions != null) {
            generator.writeKey("fuzzy_transpositions");
            generator.write(this.fuzzyTranspositions.booleanValue());
        }
        if (this.lenient != null) {
            generator.writeKey("lenient");
            generator.write(this.lenient.booleanValue());
        }
        if (this.minimumShouldMatch != null) {
            generator.writeKey("minimum_should_match");
            generator.write(this.minimumShouldMatch);
        }
        generator.writeKey("query");
        generator.write(this.query);
        if (this.quoteFieldSuffix != null) {
            generator.writeKey("quote_field_suffix");
            generator.write(this.quoteFieldSuffix);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSimpleQueryStringQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer");
        op.add(Builder::analyzeWildcard, JsonpDeserializer.booleanDeserializer(), "analyze_wildcard");
        op.add(Builder::autoGenerateSynonymsPhraseQuery, JsonpDeserializer.booleanDeserializer(), "auto_generate_synonyms_phrase_query");
        op.add(Builder::defaultOperator, Operator._DESERIALIZER, "default_operator");
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields");
        op.add(Builder::flags, JsonpDeserializer.pipeSeparatedDeserializer(SimpleQueryStringFlag._DESERIALIZER), "flags");
        op.add(Builder::fuzzyMaxExpansions, JsonpDeserializer.integerDeserializer(), "fuzzy_max_expansions");
        op.add(Builder::fuzzyPrefixLength, JsonpDeserializer.integerDeserializer(), "fuzzy_prefix_length");
        op.add(Builder::fuzzyTranspositions, JsonpDeserializer.booleanDeserializer(), "fuzzy_transpositions");
        op.add(Builder::lenient, JsonpDeserializer.booleanDeserializer(), "lenient");
        op.add(Builder::minimumShouldMatch, JsonpDeserializer.stringDeserializer(), "minimum_should_match");
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query");
        op.add(Builder::quoteFieldSuffix, JsonpDeserializer.stringDeserializer(), "quote_field_suffix");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SimpleQueryStringQuery> {
        @Nullable
        private String analyzer;
        @Nullable
        private Boolean analyzeWildcard;
        @Nullable
        private Boolean autoGenerateSynonymsPhraseQuery;
        @Nullable
        private Operator defaultOperator;
        @Nullable
        private List<String> fields;
        @Nullable
        private List<SimpleQueryStringFlag> flags;
        @Nullable
        private Integer fuzzyMaxExpansions;
        @Nullable
        private Integer fuzzyPrefixLength;
        @Nullable
        private Boolean fuzzyTranspositions;
        @Nullable
        private Boolean lenient;
        @Nullable
        private String minimumShouldMatch;
        private String query;
        @Nullable
        private String quoteFieldSuffix;

        public Builder() {
        }

        private Builder(SimpleQueryStringQuery instance) {
            this.analyzer = instance.analyzer;
            this.analyzeWildcard = instance.analyzeWildcard;
            this.autoGenerateSynonymsPhraseQuery = instance.autoGenerateSynonymsPhraseQuery;
            this.defaultOperator = instance.defaultOperator;
            this.fields = instance.fields;
            this.flags = instance.flags;
            this.fuzzyMaxExpansions = instance.fuzzyMaxExpansions;
            this.fuzzyPrefixLength = instance.fuzzyPrefixLength;
            this.fuzzyTranspositions = instance.fuzzyTranspositions;
            this.lenient = instance.lenient;
            this.minimumShouldMatch = instance.minimumShouldMatch;
            this.query = instance.query;
            this.quoteFieldSuffix = instance.quoteFieldSuffix;
        }

        public final Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public final Builder analyzeWildcard(@Nullable Boolean value) {
            this.analyzeWildcard = value;
            return this;
        }

        public final Builder autoGenerateSynonymsPhraseQuery(@Nullable Boolean value) {
            this.autoGenerateSynonymsPhraseQuery = value;
            return this;
        }

        public final Builder defaultOperator(@Nullable Operator value) {
            this.defaultOperator = value;
            return this;
        }

        public final Builder fields(List<String> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder fields(String value, String ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        public final Builder flags(List<SimpleQueryStringFlag> list) {
            this.flags = Builder._listAddAll(this.flags, list);
            return this;
        }

        public final Builder flags(SimpleQueryStringFlag value, SimpleQueryStringFlag ... values) {
            this.flags = Builder._listAdd(this.flags, value, values);
            return this;
        }

        public final Builder fuzzyMaxExpansions(@Nullable Integer value) {
            this.fuzzyMaxExpansions = value;
            return this;
        }

        public final Builder fuzzyPrefixLength(@Nullable Integer value) {
            this.fuzzyPrefixLength = value;
            return this;
        }

        public final Builder fuzzyTranspositions(@Nullable Boolean value) {
            this.fuzzyTranspositions = value;
            return this;
        }

        public final Builder lenient(@Nullable Boolean value) {
            this.lenient = value;
            return this;
        }

        public final Builder minimumShouldMatch(@Nullable String value) {
            this.minimumShouldMatch = value;
            return this;
        }

        public final Builder query(String value) {
            this.query = value;
            return this;
        }

        public final Builder quoteFieldSuffix(@Nullable String value) {
            this.quoteFieldSuffix = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SimpleQueryStringQuery build() {
            this._checkSingleUse();
            return new SimpleQueryStringQuery(this);
        }
    }
}

