/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch.security.query_api_keys.ApiKeyQuery;
import co.elastic.clients.elasticsearch.security.query_api_keys.ApiKeyQueryVariant;
import co.elastic.clients.elasticsearch.security.query_role.RoleQuery;
import co.elastic.clients.elasticsearch.security.query_role.RoleQueryVariant;
import co.elastic.clients.elasticsearch.security.query_user.UserQuery;
import co.elastic.clients.elasticsearch.security.query_user.UserQueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IdsQuery
extends QueryBase
implements ApiKeyQueryVariant,
QueryVariant,
RoleQueryVariant,
UserQueryVariant {
    private final List<String> values;
    public static final JsonpDeserializer<IdsQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IdsQuery::setupIdsQueryDeserializer);

    private IdsQuery(Builder builder) {
        super(builder);
        this.values = ApiTypeHelper.unmodifiable(builder.values);
    }

    public static IdsQuery of(Function<Builder, ObjectBuilder<IdsQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public ApiKeyQuery.Kind _apiKeyQueryKind() {
        return ApiKeyQuery.Kind.Ids;
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Ids;
    }

    @Override
    public RoleQuery.Kind _roleQueryKind() {
        return RoleQuery.Kind.Ids;
    }

    @Override
    public UserQuery.Kind _userQueryKind() {
        return UserQuery.Kind.Ids;
    }

    public final List<String> values() {
        return this.values;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.values)) {
            generator.writeKey("values");
            generator.writeStartArray();
            for (String item0 : this.values) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupIdsQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::values, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "values");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<IdsQuery> {
        @Nullable
        private List<String> values;

        public Builder() {
        }

        private Builder(IdsQuery instance) {
            this.values = instance.values;
        }

        public final Builder values(List<String> list) {
            this.values = Builder._listAddAll(this.values, list);
            return this;
        }

        public final Builder values(String value, String ... values) {
            this.values = Builder._listAdd(this.values, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IdsQuery build() {
            this._checkSingleUse();
            return new IdsQuery(this);
        }
    }
}

