/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.CorePropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.IndexOptions;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.elasticsearch._types.mapping.TermVectorOption;
import co.elastic.clients.elasticsearch._types.mapping.TextIndexPrefixes;
import co.elastic.clients.elasticsearch.indices.FielddataFrequencyFilter;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TextProperty
extends CorePropertyBase
implements PropertyVariant {
    @Nullable
    private final String analyzer;
    @Nullable
    private final Double boost;
    @Nullable
    private final Boolean eagerGlobalOrdinals;
    @Nullable
    private final Boolean fielddata;
    @Nullable
    private final FielddataFrequencyFilter fielddataFrequencyFilter;
    @Nullable
    private final Boolean index;
    @Nullable
    private final IndexOptions indexOptions;
    @Nullable
    private final Boolean indexPhrases;
    @Nullable
    private final TextIndexPrefixes indexPrefixes;
    @Nullable
    private final Boolean norms;
    @Nullable
    private final Integer positionIncrementGap;
    @Nullable
    private final String searchAnalyzer;
    @Nullable
    private final String searchQuoteAnalyzer;
    @Nullable
    private final String similarity;
    @Nullable
    private final TermVectorOption termVector;
    public static final JsonpDeserializer<TextProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TextProperty::setupTextPropertyDeserializer);

    private TextProperty(Builder builder) {
        super(builder);
        this.analyzer = builder.analyzer;
        this.boost = builder.boost;
        this.eagerGlobalOrdinals = builder.eagerGlobalOrdinals;
        this.fielddata = builder.fielddata;
        this.fielddataFrequencyFilter = builder.fielddataFrequencyFilter;
        this.index = builder.index;
        this.indexOptions = builder.indexOptions;
        this.indexPhrases = builder.indexPhrases;
        this.indexPrefixes = builder.indexPrefixes;
        this.norms = builder.norms;
        this.positionIncrementGap = builder.positionIncrementGap;
        this.searchAnalyzer = builder.searchAnalyzer;
        this.searchQuoteAnalyzer = builder.searchQuoteAnalyzer;
        this.similarity = builder.similarity;
        this.termVector = builder.termVector;
    }

    public static TextProperty of(Function<Builder, ObjectBuilder<TextProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Text;
    }

    @Nullable
    public final String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public final Double boost() {
        return this.boost;
    }

    @Nullable
    public final Boolean eagerGlobalOrdinals() {
        return this.eagerGlobalOrdinals;
    }

    @Nullable
    public final Boolean fielddata() {
        return this.fielddata;
    }

    @Nullable
    public final FielddataFrequencyFilter fielddataFrequencyFilter() {
        return this.fielddataFrequencyFilter;
    }

    @Nullable
    public final Boolean index() {
        return this.index;
    }

    @Nullable
    public final IndexOptions indexOptions() {
        return this.indexOptions;
    }

    @Nullable
    public final Boolean indexPhrases() {
        return this.indexPhrases;
    }

    @Nullable
    public final TextIndexPrefixes indexPrefixes() {
        return this.indexPrefixes;
    }

    @Nullable
    public final Boolean norms() {
        return this.norms;
    }

    @Nullable
    public final Integer positionIncrementGap() {
        return this.positionIncrementGap;
    }

    @Nullable
    public final String searchAnalyzer() {
        return this.searchAnalyzer;
    }

    @Nullable
    public final String searchQuoteAnalyzer() {
        return this.searchQuoteAnalyzer;
    }

    @Nullable
    public final String similarity() {
        return this.similarity;
    }

    @Nullable
    public final TermVectorOption termVector() {
        return this.termVector;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "text");
        super.serializeInternal(generator, mapper);
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write(this.boost.doubleValue());
        }
        if (this.eagerGlobalOrdinals != null) {
            generator.writeKey("eager_global_ordinals");
            generator.write(this.eagerGlobalOrdinals.booleanValue());
        }
        if (this.fielddata != null) {
            generator.writeKey("fielddata");
            generator.write(this.fielddata.booleanValue());
        }
        if (this.fielddataFrequencyFilter != null) {
            generator.writeKey("fielddata_frequency_filter");
            this.fielddataFrequencyFilter.serialize(generator, mapper);
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index.booleanValue());
        }
        if (this.indexOptions != null) {
            generator.writeKey("index_options");
            this.indexOptions.serialize(generator, mapper);
        }
        if (this.indexPhrases != null) {
            generator.writeKey("index_phrases");
            generator.write(this.indexPhrases.booleanValue());
        }
        if (this.indexPrefixes != null) {
            generator.writeKey("index_prefixes");
            this.indexPrefixes.serialize(generator, mapper);
        }
        if (this.norms != null) {
            generator.writeKey("norms");
            generator.write(this.norms.booleanValue());
        }
        if (this.positionIncrementGap != null) {
            generator.writeKey("position_increment_gap");
            generator.write(this.positionIncrementGap.intValue());
        }
        if (this.searchAnalyzer != null) {
            generator.writeKey("search_analyzer");
            generator.write(this.searchAnalyzer);
        }
        if (this.searchQuoteAnalyzer != null) {
            generator.writeKey("search_quote_analyzer");
            generator.write(this.searchQuoteAnalyzer);
        }
        if (this.similarity != null) {
            generator.writeKey("similarity");
            generator.write(this.similarity);
        }
        if (this.termVector != null) {
            generator.writeKey("term_vector");
            this.termVector.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupTextPropertyDeserializer(ObjectDeserializer<Builder> op) {
        CorePropertyBase.setupCorePropertyBaseDeserializer(op);
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer");
        op.add(Builder::boost, JsonpDeserializer.doubleDeserializer(), "boost");
        op.add(Builder::eagerGlobalOrdinals, JsonpDeserializer.booleanDeserializer(), "eager_global_ordinals");
        op.add(Builder::fielddata, JsonpDeserializer.booleanDeserializer(), "fielddata");
        op.add(Builder::fielddataFrequencyFilter, FielddataFrequencyFilter._DESERIALIZER, "fielddata_frequency_filter");
        op.add(Builder::index, JsonpDeserializer.booleanDeserializer(), "index");
        op.add(Builder::indexOptions, IndexOptions._DESERIALIZER, "index_options");
        op.add(Builder::indexPhrases, JsonpDeserializer.booleanDeserializer(), "index_phrases");
        op.add(Builder::indexPrefixes, TextIndexPrefixes._DESERIALIZER, "index_prefixes");
        op.add(Builder::norms, JsonpDeserializer.booleanDeserializer(), "norms");
        op.add(Builder::positionIncrementGap, JsonpDeserializer.integerDeserializer(), "position_increment_gap");
        op.add(Builder::searchAnalyzer, JsonpDeserializer.stringDeserializer(), "search_analyzer");
        op.add(Builder::searchQuoteAnalyzer, JsonpDeserializer.stringDeserializer(), "search_quote_analyzer");
        op.add(Builder::similarity, JsonpDeserializer.stringDeserializer(), "similarity");
        op.add(Builder::termVector, TermVectorOption._DESERIALIZER, "term_vector");
        op.ignore("type");
    }

    public static class Builder
    extends CorePropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TextProperty> {
        @Nullable
        private String analyzer;
        @Nullable
        private Double boost;
        @Nullable
        private Boolean eagerGlobalOrdinals;
        @Nullable
        private Boolean fielddata;
        @Nullable
        private FielddataFrequencyFilter fielddataFrequencyFilter;
        @Nullable
        private Boolean index;
        @Nullable
        private IndexOptions indexOptions;
        @Nullable
        private Boolean indexPhrases;
        @Nullable
        private TextIndexPrefixes indexPrefixes;
        @Nullable
        private Boolean norms;
        @Nullable
        private Integer positionIncrementGap;
        @Nullable
        private String searchAnalyzer;
        @Nullable
        private String searchQuoteAnalyzer;
        @Nullable
        private String similarity;
        @Nullable
        private TermVectorOption termVector;

        public Builder() {
        }

        private Builder(TextProperty instance) {
            this.analyzer = instance.analyzer;
            this.boost = instance.boost;
            this.eagerGlobalOrdinals = instance.eagerGlobalOrdinals;
            this.fielddata = instance.fielddata;
            this.fielddataFrequencyFilter = instance.fielddataFrequencyFilter;
            this.index = instance.index;
            this.indexOptions = instance.indexOptions;
            this.indexPhrases = instance.indexPhrases;
            this.indexPrefixes = instance.indexPrefixes;
            this.norms = instance.norms;
            this.positionIncrementGap = instance.positionIncrementGap;
            this.searchAnalyzer = instance.searchAnalyzer;
            this.searchQuoteAnalyzer = instance.searchQuoteAnalyzer;
            this.similarity = instance.similarity;
            this.termVector = instance.termVector;
        }

        public final Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public final Builder boost(@Nullable Double value) {
            this.boost = value;
            return this;
        }

        public final Builder eagerGlobalOrdinals(@Nullable Boolean value) {
            this.eagerGlobalOrdinals = value;
            return this;
        }

        public final Builder fielddata(@Nullable Boolean value) {
            this.fielddata = value;
            return this;
        }

        public final Builder fielddataFrequencyFilter(@Nullable FielddataFrequencyFilter value) {
            this.fielddataFrequencyFilter = value;
            return this;
        }

        public final Builder fielddataFrequencyFilter(Function<FielddataFrequencyFilter.Builder, ObjectBuilder<FielddataFrequencyFilter>> fn) {
            return this.fielddataFrequencyFilter(fn.apply(new FielddataFrequencyFilter.Builder()).build());
        }

        public final Builder index(@Nullable Boolean value) {
            this.index = value;
            return this;
        }

        public final Builder indexOptions(@Nullable IndexOptions value) {
            this.indexOptions = value;
            return this;
        }

        public final Builder indexPhrases(@Nullable Boolean value) {
            this.indexPhrases = value;
            return this;
        }

        public final Builder indexPrefixes(@Nullable TextIndexPrefixes value) {
            this.indexPrefixes = value;
            return this;
        }

        public final Builder indexPrefixes(Function<TextIndexPrefixes.Builder, ObjectBuilder<TextIndexPrefixes>> fn) {
            return this.indexPrefixes(fn.apply(new TextIndexPrefixes.Builder()).build());
        }

        public final Builder norms(@Nullable Boolean value) {
            this.norms = value;
            return this;
        }

        public final Builder positionIncrementGap(@Nullable Integer value) {
            this.positionIncrementGap = value;
            return this;
        }

        public final Builder searchAnalyzer(@Nullable String value) {
            this.searchAnalyzer = value;
            return this;
        }

        public final Builder searchQuoteAnalyzer(@Nullable String value) {
            this.searchQuoteAnalyzer = value;
            return this;
        }

        public final Builder similarity(@Nullable String value) {
            this.similarity = value;
            return this;
        }

        public final Builder termVector(@Nullable TermVectorOption value) {
            this.termVector = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TextProperty build() {
            this._checkSingleUse();
            return new TextProperty(this);
        }
    }
}

