/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.DenseVectorIndexOptions;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SemanticTextIndexOptions
implements JsonpSerializable {
    @Nullable
    private final DenseVectorIndexOptions denseVector;
    public static final JsonpDeserializer<SemanticTextIndexOptions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SemanticTextIndexOptions::setupSemanticTextIndexOptionsDeserializer);

    private SemanticTextIndexOptions(Builder builder) {
        this.denseVector = builder.denseVector;
    }

    public static SemanticTextIndexOptions of(Function<Builder, ObjectBuilder<SemanticTextIndexOptions>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final DenseVectorIndexOptions denseVector() {
        return this.denseVector;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.denseVector != null) {
            generator.writeKey("dense_vector");
            this.denseVector.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSemanticTextIndexOptionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::denseVector, DenseVectorIndexOptions._DESERIALIZER, "dense_vector");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SemanticTextIndexOptions> {
        @Nullable
        private DenseVectorIndexOptions denseVector;

        public Builder() {
        }

        private Builder(SemanticTextIndexOptions instance) {
            this.denseVector = instance.denseVector;
        }

        public final Builder denseVector(@Nullable DenseVectorIndexOptions value) {
            this.denseVector = value;
            return this;
        }

        public final Builder denseVector(Function<DenseVectorIndexOptions.Builder, ObjectBuilder<DenseVectorIndexOptions>> fn) {
            return this.denseVector(fn.apply(new DenseVectorIndexOptions.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SemanticTextIndexOptions build() {
            this._checkSingleUse();
            return new SemanticTextIndexOptions(this);
        }
    }
}

