/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.NumberPropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class HalfFloatNumberProperty
extends NumberPropertyBase
implements PropertyVariant {
    @Nullable
    private final Float nullValue;
    public static final JsonpDeserializer<HalfFloatNumberProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HalfFloatNumberProperty::setupHalfFloatNumberPropertyDeserializer);

    private HalfFloatNumberProperty(Builder builder) {
        super(builder);
        this.nullValue = builder.nullValue;
    }

    public static HalfFloatNumberProperty of(Function<Builder, ObjectBuilder<HalfFloatNumberProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.HalfFloat;
    }

    @Nullable
    public final Float nullValue() {
        return this.nullValue;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "half_float");
        super.serializeInternal(generator, mapper);
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write((double)this.nullValue.floatValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupHalfFloatNumberPropertyDeserializer(ObjectDeserializer<Builder> op) {
        NumberPropertyBase.setupNumberPropertyBaseDeserializer(op);
        op.add(Builder::nullValue, JsonpDeserializer.floatDeserializer(), "null_value");
        op.ignore("type");
    }

    public static class Builder
    extends NumberPropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<HalfFloatNumberProperty> {
        @Nullable
        private Float nullValue;

        public Builder() {
        }

        private Builder(HalfFloatNumberProperty instance) {
            this.nullValue = instance.nullValue;
        }

        public final Builder nullValue(@Nullable Float value) {
            this.nullValue = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HalfFloatNumberProperty build() {
            this._checkSingleUse();
            return new HalfFloatNumberProperty(this);
        }
    }
}

