/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.DocValuesPropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.GeoOrientation;
import co.elastic.clients.elasticsearch._types.mapping.GeoStrategy;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GeoShapeProperty
extends DocValuesPropertyBase
implements PropertyVariant {
    @Nullable
    private final Boolean coerce;
    @Nullable
    private final Boolean ignoreMalformed;
    @Nullable
    private final Boolean ignoreZValue;
    @Nullable
    private final Boolean index;
    @Nullable
    private final GeoOrientation orientation;
    @Nullable
    private final GeoStrategy strategy;
    public static final JsonpDeserializer<GeoShapeProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoShapeProperty::setupGeoShapePropertyDeserializer);

    private GeoShapeProperty(Builder builder) {
        super(builder);
        this.coerce = builder.coerce;
        this.ignoreMalformed = builder.ignoreMalformed;
        this.ignoreZValue = builder.ignoreZValue;
        this.index = builder.index;
        this.orientation = builder.orientation;
        this.strategy = builder.strategy;
    }

    public static GeoShapeProperty of(Function<Builder, ObjectBuilder<GeoShapeProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.GeoShape;
    }

    @Nullable
    public final Boolean coerce() {
        return this.coerce;
    }

    @Nullable
    public final Boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    @Nullable
    public final Boolean ignoreZValue() {
        return this.ignoreZValue;
    }

    @Nullable
    public final Boolean index() {
        return this.index;
    }

    @Nullable
    public final GeoOrientation orientation() {
        return this.orientation;
    }

    @Nullable
    public final GeoStrategy strategy() {
        return this.strategy;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "geo_shape");
        super.serializeInternal(generator, mapper);
        if (this.coerce != null) {
            generator.writeKey("coerce");
            generator.write(this.coerce.booleanValue());
        }
        if (this.ignoreMalformed != null) {
            generator.writeKey("ignore_malformed");
            generator.write(this.ignoreMalformed.booleanValue());
        }
        if (this.ignoreZValue != null) {
            generator.writeKey("ignore_z_value");
            generator.write(this.ignoreZValue.booleanValue());
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index.booleanValue());
        }
        if (this.orientation != null) {
            generator.writeKey("orientation");
            this.orientation.serialize(generator, mapper);
        }
        if (this.strategy != null) {
            generator.writeKey("strategy");
            this.strategy.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupGeoShapePropertyDeserializer(ObjectDeserializer<Builder> op) {
        DocValuesPropertyBase.setupDocValuesPropertyBaseDeserializer(op);
        op.add(Builder::coerce, JsonpDeserializer.booleanDeserializer(), "coerce");
        op.add(Builder::ignoreMalformed, JsonpDeserializer.booleanDeserializer(), "ignore_malformed");
        op.add(Builder::ignoreZValue, JsonpDeserializer.booleanDeserializer(), "ignore_z_value");
        op.add(Builder::index, JsonpDeserializer.booleanDeserializer(), "index");
        op.add(Builder::orientation, GeoOrientation._DESERIALIZER, "orientation");
        op.add(Builder::strategy, GeoStrategy._DESERIALIZER, "strategy");
        op.ignore("type");
    }

    public static class Builder
    extends DocValuesPropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoShapeProperty> {
        @Nullable
        private Boolean coerce;
        @Nullable
        private Boolean ignoreMalformed;
        @Nullable
        private Boolean ignoreZValue;
        @Nullable
        private Boolean index;
        @Nullable
        private GeoOrientation orientation;
        @Nullable
        private GeoStrategy strategy;

        public Builder() {
        }

        private Builder(GeoShapeProperty instance) {
            this.coerce = instance.coerce;
            this.ignoreMalformed = instance.ignoreMalformed;
            this.ignoreZValue = instance.ignoreZValue;
            this.index = instance.index;
            this.orientation = instance.orientation;
            this.strategy = instance.strategy;
        }

        public final Builder coerce(@Nullable Boolean value) {
            this.coerce = value;
            return this;
        }

        public final Builder ignoreMalformed(@Nullable Boolean value) {
            this.ignoreMalformed = value;
            return this;
        }

        public final Builder ignoreZValue(@Nullable Boolean value) {
            this.ignoreZValue = value;
            return this;
        }

        public final Builder index(@Nullable Boolean value) {
            this.index = value;
            return this;
        }

        public final Builder orientation(@Nullable GeoOrientation value) {
            this.orientation = value;
            return this;
        }

        public final Builder strategy(@Nullable GeoStrategy value) {
            this.strategy = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoShapeProperty build() {
            this._checkSingleUse();
            return new GeoShapeProperty(this);
        }
    }
}

