/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.KeepTypesMode;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class KeepTypesTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    @Nullable
    private final KeepTypesMode mode;
    private final List<String> types;
    public static final JsonpDeserializer<KeepTypesTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KeepTypesTokenFilter::setupKeepTypesTokenFilterDeserializer);

    private KeepTypesTokenFilter(Builder builder) {
        super(builder);
        this.mode = builder.mode;
        this.types = ApiTypeHelper.unmodifiableRequired(builder.types, (Object)this, "types");
    }

    public static KeepTypesTokenFilter of(Function<Builder, ObjectBuilder<KeepTypesTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.KeepTypes;
    }

    @Nullable
    public final KeepTypesMode mode() {
        return this.mode;
    }

    public final List<String> types() {
        return this.types;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "keep_types");
        super.serializeInternal(generator, mapper);
        if (this.mode != null) {
            generator.writeKey("mode");
            this.mode.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.types)) {
            generator.writeKey("types");
            generator.writeStartArray();
            for (String item0 : this.types) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupKeepTypesTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::mode, KeepTypesMode._DESERIALIZER, "mode");
        op.add(Builder::types, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "types");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<KeepTypesTokenFilter> {
        @Nullable
        private KeepTypesMode mode;
        private List<String> types;

        public Builder() {
        }

        private Builder(KeepTypesTokenFilter instance) {
            this.mode = instance.mode;
            this.types = instance.types;
        }

        public final Builder mode(@Nullable KeepTypesMode value) {
            this.mode = value;
            return this;
        }

        public final Builder types(List<String> list) {
            this.types = Builder._listAddAll(this.types, list);
            return this;
        }

        public final Builder types(String value, String ... values) {
            this.types = Builder._listAdd(this.types, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KeepTypesTokenFilter build() {
            this._checkSingleUse();
            return new KeepTypesTokenFilter(this);
        }
    }
}

