/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FingerprintTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    @Nullable
    private final Integer maxOutputSize;
    @Nullable
    private final String separator;
    public static final JsonpDeserializer<FingerprintTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FingerprintTokenFilter::setupFingerprintTokenFilterDeserializer);

    private FingerprintTokenFilter(Builder builder) {
        super(builder);
        this.maxOutputSize = builder.maxOutputSize;
        this.separator = builder.separator;
    }

    public static FingerprintTokenFilter of(Function<Builder, ObjectBuilder<FingerprintTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Fingerprint;
    }

    @Nullable
    public final Integer maxOutputSize() {
        return this.maxOutputSize;
    }

    @Nullable
    public final String separator() {
        return this.separator;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "fingerprint");
        super.serializeInternal(generator, mapper);
        if (this.maxOutputSize != null) {
            generator.writeKey("max_output_size");
            generator.write(this.maxOutputSize.intValue());
        }
        if (this.separator != null) {
            generator.writeKey("separator");
            generator.write(this.separator);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupFingerprintTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::maxOutputSize, JsonpDeserializer.integerDeserializer(), "max_output_size");
        op.add(Builder::separator, JsonpDeserializer.stringDeserializer(), "separator");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<FingerprintTokenFilter> {
        @Nullable
        private Integer maxOutputSize;
        @Nullable
        private String separator;

        public Builder() {
        }

        private Builder(FingerprintTokenFilter instance) {
            this.maxOutputSize = instance.maxOutputSize;
            this.separator = instance.separator;
        }

        public final Builder maxOutputSize(@Nullable Integer value) {
            this.maxOutputSize = value;
            return this;
        }

        public final Builder separator(@Nullable String value) {
            this.separator = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FingerprintTokenFilter build() {
            this._checkSingleUse();
            return new FingerprintTokenFilter(this);
        }
    }
}

