/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.ChangeType;
import co.elastic.clients.elasticsearch._types.aggregations.ChangeTypeVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class TrendChange
implements ChangeTypeVariant,
JsonpSerializable {
    private final double pValue;
    private final double rValue;
    private final int changePoint;
    public static final JsonpDeserializer<TrendChange> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrendChange::setupTrendChangeDeserializer);

    private TrendChange(Builder builder) {
        this.pValue = ApiTypeHelper.requireNonNull(builder.pValue, (Object)this, "pValue", 0.0);
        this.rValue = ApiTypeHelper.requireNonNull(builder.rValue, (Object)this, "rValue", 0.0);
        this.changePoint = ApiTypeHelper.requireNonNull(builder.changePoint, (Object)this, "changePoint", 0);
    }

    public static TrendChange of(Function<Builder, ObjectBuilder<TrendChange>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public ChangeType.Kind _changeTypeKind() {
        return ChangeType.Kind.TrendChange;
    }

    public final double pValue() {
        return this.pValue;
    }

    public final double rValue() {
        return this.rValue;
    }

    public final int changePoint() {
        return this.changePoint;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("p_value");
        generator.write(this.pValue);
        generator.writeKey("r_value");
        generator.write(this.rValue);
        generator.writeKey("change_point");
        generator.write(this.changePoint);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupTrendChangeDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::pValue, JsonpDeserializer.doubleDeserializer(), "p_value");
        op.add(Builder::rValue, JsonpDeserializer.doubleDeserializer(), "r_value");
        op.add(Builder::changePoint, JsonpDeserializer.integerDeserializer(), "change_point");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TrendChange> {
        private Double pValue;
        private Double rValue;
        private Integer changePoint;

        public Builder() {
        }

        private Builder(TrendChange instance) {
            this.pValue = instance.pValue;
            this.rValue = instance.rValue;
            this.changePoint = instance.changePoint;
        }

        public final Builder pValue(double value) {
            this.pValue = value;
            return this;
        }

        public final Builder rValue(double value) {
            this.rValue = value;
            return this;
        }

        public final Builder changePoint(int value) {
            this.changePoint = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TrendChange build() {
            this._checkSingleUse();
            return new TrendChange(this);
        }
    }
}

