/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateBase;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateVariant;
import co.elastic.clients.elasticsearch._types.aggregations.TopMetrics;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class TopMetricsAggregate
extends AggregateBase
implements AggregateVariant {
    private final List<TopMetrics> top;
    public static final JsonpDeserializer<TopMetricsAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TopMetricsAggregate::setupTopMetricsAggregateDeserializer);

    private TopMetricsAggregate(Builder builder) {
        super(builder);
        this.top = ApiTypeHelper.unmodifiableRequired(builder.top, (Object)this, "top");
    }

    public static TopMetricsAggregate of(Function<Builder, ObjectBuilder<TopMetricsAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.TopMetrics;
    }

    public final List<TopMetrics> top() {
        return this.top;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.top)) {
            generator.writeKey("top");
            generator.writeStartArray();
            for (TopMetrics item0 : this.top) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupTopMetricsAggregateDeserializer(ObjectDeserializer<Builder> op) {
        AggregateBase.setupAggregateBaseDeserializer(op);
        op.add(Builder::top, JsonpDeserializer.arrayDeserializer(TopMetrics._DESERIALIZER), "top");
    }

    public static class Builder
    extends AggregateBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TopMetricsAggregate> {
        private List<TopMetrics> top;

        public Builder() {
        }

        private Builder(TopMetricsAggregate instance) {
            this.top = instance.top;
        }

        public final Builder top(List<TopMetrics> list) {
            this.top = Builder._listAddAll(this.top, list);
            return this;
        }

        public final Builder top(TopMetrics value, TopMetrics ... values) {
            this.top = Builder._listAdd(this.top, value, values);
            return this;
        }

        public final Builder top(Function<TopMetrics.Builder, ObjectBuilder<TopMetrics>> fn) {
            return this.top(fn.apply(new TopMetrics.Builder()).build(), new TopMetrics[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TopMetricsAggregate build() {
            this._checkSingleUse();
            return new TopMetricsAggregate(this);
        }
    }
}

