/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NestedAggregation
extends BucketAggregationBase
implements AggregationVariant,
JsonpSerializable {
    @Nullable
    private final String path;
    public static final JsonpDeserializer<NestedAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NestedAggregation::setupNestedAggregationDeserializer);

    private NestedAggregation(Builder builder) {
        this.path = builder.path;
    }

    public static NestedAggregation of(Function<Builder, ObjectBuilder<NestedAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Nested;
    }

    @Nullable
    public final String path() {
        return this.path;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.path != null) {
            generator.writeKey("path");
            generator.write(this.path);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupNestedAggregationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::path, JsonpDeserializer.stringDeserializer(), "path");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<NestedAggregation> {
        @Nullable
        private String path;

        public Builder() {
        }

        private Builder(NestedAggregation instance) {
            this.path = instance.path;
        }

        public final Builder path(@Nullable String value) {
            this.path = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NestedAggregation build() {
            this._checkSingleUse();
            return new NestedAggregation(this);
        }
    }
}

