/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.MultiTermLookup;
import co.elastic.clients.elasticsearch._types.aggregations.TermsAggregationCollectMode;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.NamedValue;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MultiTermsAggregation
extends BucketAggregationBase
implements AggregationVariant,
JsonpSerializable {
    @Nullable
    private final TermsAggregationCollectMode collectMode;
    private final List<NamedValue<SortOrder>> order;
    @Nullable
    private final Long minDocCount;
    @Nullable
    private final Long shardMinDocCount;
    @Nullable
    private final Integer shardSize;
    @Nullable
    private final Boolean showTermDocCountError;
    @Nullable
    private final Integer size;
    private final List<MultiTermLookup> terms;
    public static final JsonpDeserializer<MultiTermsAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MultiTermsAggregation::setupMultiTermsAggregationDeserializer);

    private MultiTermsAggregation(Builder builder) {
        this.collectMode = builder.collectMode;
        this.order = ApiTypeHelper.unmodifiable(builder.order);
        this.minDocCount = builder.minDocCount;
        this.shardMinDocCount = builder.shardMinDocCount;
        this.shardSize = builder.shardSize;
        this.showTermDocCountError = builder.showTermDocCountError;
        this.size = builder.size;
        this.terms = ApiTypeHelper.unmodifiableRequired(builder.terms, (Object)this, "terms");
    }

    public static MultiTermsAggregation of(Function<Builder, ObjectBuilder<MultiTermsAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.MultiTerms;
    }

    @Nullable
    public final TermsAggregationCollectMode collectMode() {
        return this.collectMode;
    }

    public final List<NamedValue<SortOrder>> order() {
        return this.order;
    }

    @Nullable
    public final Long minDocCount() {
        return this.minDocCount;
    }

    @Nullable
    public final Long shardMinDocCount() {
        return this.shardMinDocCount;
    }

    @Nullable
    public final Integer shardSize() {
        return this.shardSize;
    }

    @Nullable
    public final Boolean showTermDocCountError() {
        return this.showTermDocCountError;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    public final List<MultiTermLookup> terms() {
        return this.terms;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.collectMode != null) {
            generator.writeKey("collect_mode");
            this.collectMode.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.order)) {
            generator.writeKey("order");
            generator.writeStartArray();
            for (NamedValue<SortOrder> namedValue : this.order) {
                generator.writeStartObject();
                generator.writeKey(namedValue.name());
                namedValue.value().serialize(generator, mapper);
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.minDocCount != null) {
            generator.writeKey("min_doc_count");
            generator.write(this.minDocCount.longValue());
        }
        if (this.shardMinDocCount != null) {
            generator.writeKey("shard_min_doc_count");
            generator.write(this.shardMinDocCount.longValue());
        }
        if (this.shardSize != null) {
            generator.writeKey("shard_size");
            generator.write(this.shardSize.intValue());
        }
        if (this.showTermDocCountError != null) {
            generator.writeKey("show_term_doc_count_error");
            generator.write(this.showTermDocCountError.booleanValue());
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (ApiTypeHelper.isDefined(this.terms)) {
            generator.writeKey("terms");
            generator.writeStartArray();
            for (MultiTermLookup multiTermLookup : this.terms) {
                multiTermLookup.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupMultiTermsAggregationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::collectMode, TermsAggregationCollectMode._DESERIALIZER, "collect_mode");
        op.add(Builder::order, JsonpDeserializer.arrayDeserializer(NamedValue.deserializer(() -> SortOrder._DESERIALIZER)), "order");
        op.add(Builder::minDocCount, JsonpDeserializer.longDeserializer(), "min_doc_count");
        op.add(Builder::shardMinDocCount, JsonpDeserializer.longDeserializer(), "shard_min_doc_count");
        op.add(Builder::shardSize, JsonpDeserializer.integerDeserializer(), "shard_size");
        op.add(Builder::showTermDocCountError, JsonpDeserializer.booleanDeserializer(), "show_term_doc_count_error");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(Builder::terms, JsonpDeserializer.arrayDeserializer(MultiTermLookup._DESERIALIZER), "terms");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MultiTermsAggregation> {
        @Nullable
        private TermsAggregationCollectMode collectMode;
        @Nullable
        private List<NamedValue<SortOrder>> order;
        @Nullable
        private Long minDocCount;
        @Nullable
        private Long shardMinDocCount;
        @Nullable
        private Integer shardSize;
        @Nullable
        private Boolean showTermDocCountError;
        @Nullable
        private Integer size;
        private List<MultiTermLookup> terms;

        public Builder() {
        }

        private Builder(MultiTermsAggregation instance) {
            this.collectMode = instance.collectMode;
            this.order = instance.order;
            this.minDocCount = instance.minDocCount;
            this.shardMinDocCount = instance.shardMinDocCount;
            this.shardSize = instance.shardSize;
            this.showTermDocCountError = instance.showTermDocCountError;
            this.size = instance.size;
            this.terms = instance.terms;
        }

        public final Builder collectMode(@Nullable TermsAggregationCollectMode value) {
            this.collectMode = value;
            return this;
        }

        public final Builder order(List<NamedValue<SortOrder>> list) {
            this.order = Builder._listAddAll(this.order, list);
            return this;
        }

        @SafeVarargs
        public final Builder order(NamedValue<SortOrder> value, NamedValue<SortOrder> ... values) {
            this.order = Builder._listAdd(this.order, value, values);
            return this;
        }

        public final Builder minDocCount(@Nullable Long value) {
            this.minDocCount = value;
            return this;
        }

        public final Builder shardMinDocCount(@Nullable Long value) {
            this.shardMinDocCount = value;
            return this;
        }

        public final Builder shardSize(@Nullable Integer value) {
            this.shardSize = value;
            return this;
        }

        public final Builder showTermDocCountError(@Nullable Boolean value) {
            this.showTermDocCountError = value;
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder terms(List<MultiTermLookup> list) {
            this.terms = Builder._listAddAll(this.terms, list);
            return this;
        }

        public final Builder terms(MultiTermLookup value, MultiTermLookup ... values) {
            this.terms = Builder._listAdd(this.terms, value, values);
            return this;
        }

        public final Builder terms(Function<MultiTermLookup.Builder, ObjectBuilder<MultiTermLookup>> fn) {
            return this.terms(fn.apply(new MultiTermLookup.Builder()).build(), new MultiTermLookup[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MultiTermsAggregation build() {
            this._checkSingleUse();
            return new MultiTermsAggregation(this);
        }
    }
}

