/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.FormatMetricAggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.TDigestExecutionHint;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MedianAbsoluteDeviationAggregation
extends FormatMetricAggregationBase
implements AggregationVariant {
    @Nullable
    private final Double compression;
    @Nullable
    private final TDigestExecutionHint executionHint;
    public static final JsonpDeserializer<MedianAbsoluteDeviationAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MedianAbsoluteDeviationAggregation::setupMedianAbsoluteDeviationAggregationDeserializer);

    private MedianAbsoluteDeviationAggregation(Builder builder) {
        super(builder);
        this.compression = builder.compression;
        this.executionHint = builder.executionHint;
    }

    public static MedianAbsoluteDeviationAggregation of(Function<Builder, ObjectBuilder<MedianAbsoluteDeviationAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.MedianAbsoluteDeviation;
    }

    @Nullable
    public final Double compression() {
        return this.compression;
    }

    @Nullable
    public final TDigestExecutionHint executionHint() {
        return this.executionHint;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.compression != null) {
            generator.writeKey("compression");
            generator.write(this.compression.doubleValue());
        }
        if (this.executionHint != null) {
            generator.writeKey("execution_hint");
            this.executionHint.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupMedianAbsoluteDeviationAggregationDeserializer(ObjectDeserializer<Builder> op) {
        FormatMetricAggregationBase.setupFormatMetricAggregationBaseDeserializer(op);
        op.add(Builder::compression, JsonpDeserializer.doubleDeserializer(), "compression");
        op.add(Builder::executionHint, TDigestExecutionHint._DESERIALIZER, "execution_hint");
    }

    public static class Builder
    extends FormatMetricAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MedianAbsoluteDeviationAggregation> {
        @Nullable
        private Double compression;
        @Nullable
        private TDigestExecutionHint executionHint;

        public Builder() {
        }

        private Builder(MedianAbsoluteDeviationAggregation instance) {
            this.compression = instance.compression;
            this.executionHint = instance.executionHint;
        }

        public final Builder compression(@Nullable Double value) {
            this.compression = value;
            return this;
        }

        public final Builder executionHint(@Nullable TDigestExecutionHint value) {
            this.executionHint = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MedianAbsoluteDeviationAggregation build() {
            this._checkSingleUse();
            return new MedianAbsoluteDeviationAggregation(this);
        }
    }
}

