/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.InferenceClassImportance;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class InferenceFeatureImportance
implements JsonpSerializable {
    private final String featureName;
    @Nullable
    private final Double importance;
    private final List<InferenceClassImportance> classes;
    public static final JsonpDeserializer<InferenceFeatureImportance> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InferenceFeatureImportance::setupInferenceFeatureImportanceDeserializer);

    private InferenceFeatureImportance(Builder builder) {
        this.featureName = ApiTypeHelper.requireNonNull(builder.featureName, this, "featureName");
        this.importance = builder.importance;
        this.classes = ApiTypeHelper.unmodifiable(builder.classes);
    }

    public static InferenceFeatureImportance of(Function<Builder, ObjectBuilder<InferenceFeatureImportance>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String featureName() {
        return this.featureName;
    }

    @Nullable
    public final Double importance() {
        return this.importance;
    }

    public final List<InferenceClassImportance> classes() {
        return this.classes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("feature_name");
        generator.write(this.featureName);
        if (this.importance != null) {
            generator.writeKey("importance");
            generator.write(this.importance.doubleValue());
        }
        if (ApiTypeHelper.isDefined(this.classes)) {
            generator.writeKey("classes");
            generator.writeStartArray();
            for (InferenceClassImportance item0 : this.classes) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupInferenceFeatureImportanceDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::featureName, JsonpDeserializer.stringDeserializer(), "feature_name");
        op.add(Builder::importance, JsonpDeserializer.doubleDeserializer(), "importance");
        op.add(Builder::classes, JsonpDeserializer.arrayDeserializer(InferenceClassImportance._DESERIALIZER), "classes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<InferenceFeatureImportance> {
        private String featureName;
        @Nullable
        private Double importance;
        @Nullable
        private List<InferenceClassImportance> classes;

        public Builder() {
        }

        private Builder(InferenceFeatureImportance instance) {
            this.featureName = instance.featureName;
            this.importance = instance.importance;
            this.classes = instance.classes;
        }

        public final Builder featureName(String value) {
            this.featureName = value;
            return this;
        }

        public final Builder importance(@Nullable Double value) {
            this.importance = value;
            return this;
        }

        public final Builder classes(List<InferenceClassImportance> list) {
            this.classes = Builder._listAddAll(this.classes, list);
            return this;
        }

        public final Builder classes(InferenceClassImportance value, InferenceClassImportance ... values) {
            this.classes = Builder._listAdd(this.classes, value, values);
            return this;
        }

        public final Builder classes(Function<InferenceClassImportance.Builder, ObjectBuilder<InferenceClassImportance>> fn) {
            return this.classes(fn.apply(new InferenceClassImportance.Builder()).build(), new InferenceClassImportance[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InferenceFeatureImportance build() {
            this._checkSingleUse();
            return new InferenceFeatureImportance(this);
        }
    }
}

