/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.GeoBounds;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.elasticsearch.transform.PivotGroupBy;
import co.elastic.clients.elasticsearch.transform.PivotGroupByVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GeoTileGridAggregation
extends BucketAggregationBase
implements AggregationVariant,
PivotGroupByVariant,
JsonpSerializable {
    @Nullable
    private final String field;
    @Nullable
    private final Number precision;
    @Nullable
    private final Integer shardSize;
    @Nullable
    private final Integer size;
    @Nullable
    private final GeoBounds bounds;
    public static final JsonpDeserializer<GeoTileGridAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoTileGridAggregation::setupGeoTileGridAggregationDeserializer);

    private GeoTileGridAggregation(Builder builder) {
        this.field = builder.field;
        this.precision = builder.precision;
        this.shardSize = builder.shardSize;
        this.size = builder.size;
        this.bounds = builder.bounds;
    }

    public static GeoTileGridAggregation of(Function<Builder, ObjectBuilder<GeoTileGridAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.GeotileGrid;
    }

    @Override
    public PivotGroupBy.Kind _pivotGroupByKind() {
        return PivotGroupBy.Kind.GeotileGrid;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Number precision() {
        return this.precision;
    }

    @Nullable
    public final Integer shardSize() {
        return this.shardSize;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final GeoBounds bounds() {
        return this.bounds;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.precision != null) {
            generator.writeKey("precision");
            generator.write(this.precision.doubleValue());
        }
        if (this.shardSize != null) {
            generator.writeKey("shard_size");
            generator.write(this.shardSize.intValue());
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (this.bounds != null) {
            generator.writeKey("bounds");
            this.bounds.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupGeoTileGridAggregationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::precision, JsonpDeserializer.numberDeserializer(), "precision");
        op.add(Builder::shardSize, JsonpDeserializer.integerDeserializer(), "shard_size");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(Builder::bounds, GeoBounds._DESERIALIZER, "bounds");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoTileGridAggregation> {
        @Nullable
        private String field;
        @Nullable
        private Number precision;
        @Nullable
        private Integer shardSize;
        @Nullable
        private Integer size;
        @Nullable
        private GeoBounds bounds;

        public Builder() {
        }

        private Builder(GeoTileGridAggregation instance) {
            this.field = instance.field;
            this.precision = instance.precision;
            this.shardSize = instance.shardSize;
            this.size = instance.size;
            this.bounds = instance.bounds;
        }

        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public final Builder precision(@Nullable Number value) {
            this.precision = value;
            return this;
        }

        public final Builder shardSize(@Nullable Integer value) {
            this.shardSize = value;
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder bounds(@Nullable GeoBounds value) {
            this.bounds = value;
            return this;
        }

        public final Builder bounds(Function<GeoBounds.Builder, ObjectBuilder<GeoBounds>> fn) {
            return this.bounds(fn.apply(new GeoBounds.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoTileGridAggregation build() {
            this._checkSingleUse();
            return new GeoTileGridAggregation(this);
        }
    }
}

