/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.CartesianPoint;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateBase;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CartesianCentroidAggregate
extends AggregateBase
implements AggregateVariant {
    private final long count;
    @Nullable
    private final CartesianPoint location;
    public static final JsonpDeserializer<CartesianCentroidAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CartesianCentroidAggregate::setupCartesianCentroidAggregateDeserializer);

    private CartesianCentroidAggregate(Builder builder) {
        super(builder);
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0L);
        this.location = builder.location;
    }

    public static CartesianCentroidAggregate of(Function<Builder, ObjectBuilder<CartesianCentroidAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.CartesianCentroid;
    }

    public final long count() {
        return this.count;
    }

    @Nullable
    public final CartesianPoint location() {
        return this.location;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("count");
        generator.write(this.count);
        if (this.location != null) {
            generator.writeKey("location");
            this.location.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupCartesianCentroidAggregateDeserializer(ObjectDeserializer<Builder> op) {
        AggregateBase.setupAggregateBaseDeserializer(op);
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::location, CartesianPoint._DESERIALIZER, "location");
    }

    public static class Builder
    extends AggregateBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CartesianCentroidAggregate> {
        private Long count;
        @Nullable
        private CartesianPoint location;

        public Builder() {
        }

        private Builder(CartesianCentroidAggregate instance) {
            this.count = instance.count;
            this.location = instance.location;
        }

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder location(@Nullable CartesianPoint value) {
            this.location = value;
            return this;
        }

        public final Builder location(Function<CartesianPoint.Builder, ObjectBuilder<CartesianPoint>> fn) {
            return this.location(fn.apply(new CartesianPoint.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CartesianCentroidAggregate build() {
            this._checkSingleUse();
            return new CartesianCentroidAggregate(this);
        }
    }
}

