/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class AdjacencyMatrixBucket
extends MultiBucketBase {
    private final String key;
    public static final JsonpDeserializer<AdjacencyMatrixBucket> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AdjacencyMatrixBucket::setupAdjacencyMatrixBucketDeserializer);

    private AdjacencyMatrixBucket(Builder builder) {
        super(builder);
        this.key = ApiTypeHelper.requireNonNull(builder.key, this, "key");
    }

    public static AdjacencyMatrixBucket of(Function<Builder, ObjectBuilder<AdjacencyMatrixBucket>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String key() {
        return this.key;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("key");
        generator.write(this.key);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupAdjacencyMatrixBucketDeserializer(ObjectDeserializer<Builder> op) {
        MultiBucketBase.setupMultiBucketBaseDeserializer(op);
        op.add(Builder::key, JsonpDeserializer.stringDeserializer(), "key");
    }

    public static class Builder
    extends MultiBucketBase.AbstractBuilder<Builder>
    implements ObjectBuilder<AdjacencyMatrixBucket> {
        private String key;

        public Builder() {
        }

        private Builder(AdjacencyMatrixBucket instance) {
            this.key = instance.key;
        }

        public final Builder key(String value) {
            this.key = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AdjacencyMatrixBucket build() {
            this._checkSingleUse();
            return new AdjacencyMatrixBucket(this);
        }
    }
}

