/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.ShardFailure;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ShardStatistics
implements JsonpSerializable {
    private final Number failed;
    private final Number successful;
    private final Number total;
    private final List<ShardFailure> failures;
    @Nullable
    private final Number skipped;
    public static final JsonpDeserializer<ShardStatistics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardStatistics::setupShardStatisticsDeserializer);

    private ShardStatistics(Builder builder) {
        this.failed = ApiTypeHelper.requireNonNull(builder.failed, this, "failed");
        this.successful = ApiTypeHelper.requireNonNull(builder.successful, this, "successful");
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
        this.failures = ApiTypeHelper.unmodifiable(builder.failures);
        this.skipped = builder.skipped;
    }

    public static ShardStatistics of(Function<Builder, ObjectBuilder<ShardStatistics>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Number failed() {
        return this.failed;
    }

    public final Number successful() {
        return this.successful;
    }

    public final Number total() {
        return this.total;
    }

    public final List<ShardFailure> failures() {
        return this.failures;
    }

    @Nullable
    public final Number skipped() {
        return this.skipped;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("failed");
        generator.write(this.failed.doubleValue());
        generator.writeKey("successful");
        generator.write(this.successful.doubleValue());
        generator.writeKey("total");
        generator.write(this.total.doubleValue());
        if (ApiTypeHelper.isDefined(this.failures)) {
            generator.writeKey("failures");
            generator.writeStartArray();
            for (ShardFailure item0 : this.failures) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.skipped != null) {
            generator.writeKey("skipped");
            generator.write(this.skipped.doubleValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupShardStatisticsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::failed, JsonpDeserializer.numberDeserializer(), "failed");
        op.add(Builder::successful, JsonpDeserializer.numberDeserializer(), "successful");
        op.add(Builder::total, JsonpDeserializer.numberDeserializer(), "total");
        op.add(Builder::failures, JsonpDeserializer.arrayDeserializer(ShardFailure._DESERIALIZER), "failures");
        op.add(Builder::skipped, JsonpDeserializer.numberDeserializer(), "skipped");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ShardStatistics> {
        private Number failed;
        private Number successful;
        private Number total;
        @Nullable
        private List<ShardFailure> failures;
        @Nullable
        private Number skipped;

        public Builder() {
        }

        private Builder(ShardStatistics instance) {
            this.failed = instance.failed;
            this.successful = instance.successful;
            this.total = instance.total;
            this.failures = instance.failures;
            this.skipped = instance.skipped;
        }

        public final Builder failed(Number value) {
            this.failed = value;
            return this;
        }

        public final Builder successful(Number value) {
            this.successful = value;
            return this;
        }

        public final Builder total(Number value) {
            this.total = value;
            return this;
        }

        public final Builder failures(List<ShardFailure> list) {
            this.failures = Builder._listAddAll(this.failures, list);
            return this;
        }

        public final Builder failures(ShardFailure value, ShardFailure ... values) {
            this.failures = Builder._listAdd(this.failures, value, values);
            return this;
        }

        public final Builder failures(Function<ShardFailure.Builder, ObjectBuilder<ShardFailure>> fn) {
            return this.failures(fn.apply(new ShardFailure.Builder()).build(), new ShardFailure[0]);
        }

        public final Builder skipped(@Nullable Number value) {
            this.skipped = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ShardStatistics build() {
            this._checkSingleUse();
            return new ShardStatistics(this);
        }
    }
}

