/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RequestCacheStats
implements JsonpSerializable {
    private final long evictions;
    private final long hitCount;
    @Nullable
    private final String memorySize;
    private final long memorySizeInBytes;
    private final long missCount;
    public static final JsonpDeserializer<RequestCacheStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RequestCacheStats::setupRequestCacheStatsDeserializer);

    private RequestCacheStats(Builder builder) {
        this.evictions = ApiTypeHelper.requireNonNull(builder.evictions, (Object)this, "evictions", 0L);
        this.hitCount = ApiTypeHelper.requireNonNull(builder.hitCount, (Object)this, "hitCount", 0L);
        this.memorySize = builder.memorySize;
        this.memorySizeInBytes = ApiTypeHelper.requireNonNull(builder.memorySizeInBytes, (Object)this, "memorySizeInBytes", 0L);
        this.missCount = ApiTypeHelper.requireNonNull(builder.missCount, (Object)this, "missCount", 0L);
    }

    public static RequestCacheStats of(Function<Builder, ObjectBuilder<RequestCacheStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long evictions() {
        return this.evictions;
    }

    public final long hitCount() {
        return this.hitCount;
    }

    @Nullable
    public final String memorySize() {
        return this.memorySize;
    }

    public final long memorySizeInBytes() {
        return this.memorySizeInBytes;
    }

    public final long missCount() {
        return this.missCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("evictions");
        generator.write(this.evictions);
        generator.writeKey("hit_count");
        generator.write(this.hitCount);
        if (this.memorySize != null) {
            generator.writeKey("memory_size");
            generator.write(this.memorySize);
        }
        generator.writeKey("memory_size_in_bytes");
        generator.write(this.memorySizeInBytes);
        generator.writeKey("miss_count");
        generator.write(this.missCount);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupRequestCacheStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::evictions, JsonpDeserializer.longDeserializer(), "evictions");
        op.add(Builder::hitCount, JsonpDeserializer.longDeserializer(), "hit_count");
        op.add(Builder::memorySize, JsonpDeserializer.stringDeserializer(), "memory_size");
        op.add(Builder::memorySizeInBytes, JsonpDeserializer.longDeserializer(), "memory_size_in_bytes");
        op.add(Builder::missCount, JsonpDeserializer.longDeserializer(), "miss_count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RequestCacheStats> {
        private Long evictions;
        private Long hitCount;
        @Nullable
        private String memorySize;
        private Long memorySizeInBytes;
        private Long missCount;

        public Builder() {
        }

        private Builder(RequestCacheStats instance) {
            this.evictions = instance.evictions;
            this.hitCount = instance.hitCount;
            this.memorySize = instance.memorySize;
            this.memorySizeInBytes = instance.memorySizeInBytes;
            this.missCount = instance.missCount;
        }

        public final Builder evictions(long value) {
            this.evictions = value;
            return this;
        }

        public final Builder hitCount(long value) {
            this.hitCount = value;
            return this;
        }

        public final Builder memorySize(@Nullable String value) {
            this.memorySize = value;
            return this;
        }

        public final Builder memorySizeInBytes(long value) {
            this.memorySizeInBytes = value;
            return this;
        }

        public final Builder missCount(long value) {
            this.missCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RequestCacheStats build() {
            this._checkSingleUse();
            return new RequestCacheStats(this);
        }
    }
}

