/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package co.elastic.clients.elasticsearch.rollup;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.lang.Boolean;
import java.lang.String;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

//----------------------------------------------------------------
//       THIS CODE IS GENERATED. MANUAL EDITS WILL BE LOST.
//----------------------------------------------------------------
//
// This code is generated from the Elasticsearch API specification
// at https://github.com/elastic/elasticsearch-specification
//
// Manual updates to this file will be lost when the code is
// re-generated.
//
// If you find a property that is missing or wrongly typed, please
// open an issue or a PR on the API specification repository.
//
//----------------------------------------------------------------

// typedef: rollup.stop_job.Request

/**
 * Stop rollup jobs. If you try to stop a job that does not exist, an exception
 * occurs. If you try to stop a job that is already stopped, nothing happens.
 * <p>
 * Since only a stopped job can be deleted, it can be useful to block the API
 * until the indexer has fully stopped. This is accomplished with the
 * <code>wait_for_completion</code> query parameter, and optionally a timeout.
 * For example:
 * 
 * <pre>
 * <code>POST _rollup/job/sensor/_stop?wait_for_completion=true&amp;timeout=10s
 * </code>
 * </pre>
 * <p>
 * The parameter blocks the API call from returning until either the job has
 * moved to STOPPED or the specified time has elapsed. If the specified time
 * elapses without the job moving to STOPPED, a timeout exception occurs.
 * 
 * @see <a href="../doc-files/api-spec.html#rollup.stop_job.Request">API
 *      specification</a>
 * @deprecated 8.11.0
 */
@Deprecated
public class StopJobRequest extends RequestBase {
	private final String id;

	@Nullable
	private final Time timeout;

	@Nullable
	private final Boolean waitForCompletion;

	// ---------------------------------------------------------------------------------------------

	private StopJobRequest(Builder builder) {

		this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
		this.timeout = builder.timeout;
		this.waitForCompletion = builder.waitForCompletion;

	}

	public static StopJobRequest of(Function<Builder, ObjectBuilder<StopJobRequest>> fn) {
		return fn.apply(new Builder()).build();
	}

	/**
	 * Required - Identifier for the rollup job.
	 * <p>
	 * API name: {@code id}
	 */
	public final String id() {
		return this.id;
	}

	/**
	 * If <code>wait_for_completion</code> is <code>true</code>, the API blocks for
	 * (at maximum) the specified duration while waiting for the job to stop. If
	 * more than <code>timeout</code> time has passed, the API throws a timeout
	 * exception. NOTE: Even if a timeout occurs, the stop request is still
	 * processing and eventually moves the job to STOPPED. The timeout simply means
	 * the API call itself timed out while waiting for the status change.
	 * <p>
	 * API name: {@code timeout}
	 */
	@Nullable
	public final Time timeout() {
		return this.timeout;
	}

	/**
	 * If set to <code>true</code>, causes the API to block until the indexer state
	 * completely stops. If set to <code>false</code>, the API returns immediately
	 * and the indexer is stopped asynchronously in the background.
	 * <p>
	 * API name: {@code wait_for_completion}
	 */
	@Nullable
	public final Boolean waitForCompletion() {
		return this.waitForCompletion;
	}

	// ---------------------------------------------------------------------------------------------

	/**
	 * Builder for {@link StopJobRequest}.
	 */
	@Deprecated
	public static class Builder extends RequestBase.AbstractBuilder<Builder> implements ObjectBuilder<StopJobRequest> {
		private String id;

		@Nullable
		private Time timeout;

		@Nullable
		private Boolean waitForCompletion;

		public Builder() {
		}
		private Builder(StopJobRequest instance) {
			this.id = instance.id;
			this.timeout = instance.timeout;
			this.waitForCompletion = instance.waitForCompletion;

		}
		/**
		 * Required - Identifier for the rollup job.
		 * <p>
		 * API name: {@code id}
		 */
		public final Builder id(String value) {
			this.id = value;
			return this;
		}

		/**
		 * If <code>wait_for_completion</code> is <code>true</code>, the API blocks for
		 * (at maximum) the specified duration while waiting for the job to stop. If
		 * more than <code>timeout</code> time has passed, the API throws a timeout
		 * exception. NOTE: Even if a timeout occurs, the stop request is still
		 * processing and eventually moves the job to STOPPED. The timeout simply means
		 * the API call itself timed out while waiting for the status change.
		 * <p>
		 * API name: {@code timeout}
		 */
		public final Builder timeout(@Nullable Time value) {
			this.timeout = value;
			return this;
		}

		/**
		 * If <code>wait_for_completion</code> is <code>true</code>, the API blocks for
		 * (at maximum) the specified duration while waiting for the job to stop. If
		 * more than <code>timeout</code> time has passed, the API throws a timeout
		 * exception. NOTE: Even if a timeout occurs, the stop request is still
		 * processing and eventually moves the job to STOPPED. The timeout simply means
		 * the API call itself timed out while waiting for the status change.
		 * <p>
		 * API name: {@code timeout}
		 */
		public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
			return this.timeout(fn.apply(new Time.Builder()).build());
		}

		/**
		 * If set to <code>true</code>, causes the API to block until the indexer state
		 * completely stops. If set to <code>false</code>, the API returns immediately
		 * and the indexer is stopped asynchronously in the background.
		 * <p>
		 * API name: {@code wait_for_completion}
		 */
		public final Builder waitForCompletion(@Nullable Boolean value) {
			this.waitForCompletion = value;
			return this;
		}

		@Override
		protected Builder self() {
			return this;
		}

		/**
		 * Builds a {@link StopJobRequest}.
		 *
		 * @throws NullPointerException
		 *             if some of the required fields are null.
		 */
		public StopJobRequest build() {
			_checkSingleUse();

			return new StopJobRequest(this);
		}
	}

	/**
	 * @return New {@link Builder} initialized with field values of this instance
	 */
	public Builder rebuild() {
		return new Builder(this);
	}
	// ---------------------------------------------------------------------------------------------

	/**
	 * Endpoint "{@code rollup.stop_job}".
	 */
	public static final Endpoint<StopJobRequest, StopJobResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<>(
			"es/rollup.stop_job",

			// Request method
			request -> {
				return "POST";

			},

			// Request path
			request -> {
				final int _id = 1 << 0;

				int propsSet = 0;

				propsSet |= _id;

				if (propsSet == (_id)) {
					StringBuilder buf = new StringBuilder();
					buf.append("/_rollup");
					buf.append("/job");
					buf.append("/");
					SimpleEndpoint.pathEncode(request.id, buf);
					buf.append("/_stop");
					return buf.toString();
				}
				throw SimpleEndpoint.noPathTemplateFound("path");

			},

			// Path parameters
			request -> {
				Map<String, String> params = new HashMap<>();
				final int _id = 1 << 0;

				int propsSet = 0;

				propsSet |= _id;

				if (propsSet == (_id)) {
					params.put("id", request.id);
				}
				return params;
			},

			// Request parameters
			request -> {
				Map<String, String> params = new HashMap<>();
				if (request.waitForCompletion != null) {
					params.put("wait_for_completion", String.valueOf(request.waitForCompletion));
				}
				if (request.timeout != null) {
					params.put("timeout", request.timeout._toJsonString());
				}
				return params;

			}, SimpleEndpoint.emptyMap(), false, StopJobResponse._DESERIALIZER);
}
