/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json.jackson;

import co.elastic.clients.json.JsonBuffer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.jackson.JacksonJsonpGenerator;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpParser;
import co.elastic.clients.json.jackson.JacksonUtils;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;

class JacksonJsonBuffer
implements JsonBuffer,
JsonData {
    private final TokenBuffer buffer;
    private final JacksonJsonpMapper mapper;

    JacksonJsonBuffer(TokenBuffer buffer, JacksonJsonpMapper mapper) {
        this.buffer = buffer;
        this.mapper = mapper;
    }

    @Override
    public JsonParser asParser() {
        return new JacksonJsonpParser(this.buffer.asParser(), this.mapper);
    }

    @Override
    public JsonValue toJson() {
        try (JsonParser parser = this.asParser();){
            parser.next();
            JsonValue jsonValue = parser.getValue();
            return jsonValue;
        }
    }

    @Override
    public JsonValue toJson(JsonpMapper mapper) {
        return this.toJson();
    }

    @Override
    public <T> T to(Type type) {
        return this.to(type, (JsonpMapper)this.mapper);
    }

    @Override
    public <T> T to(Type type, JsonpMapper mapper) {
        try (JsonParser parser = this.asParser();){
            Object t = mapper.deserialize(parser, type);
            return t;
        }
    }

    @Override
    public <T> T deserialize(JsonpDeserializer<T> deserializer) {
        return this.deserialize(deserializer, this.mapper);
    }

    @Override
    public <T> T deserialize(JsonpDeserializer<T> deserializer, JsonpMapper mapper) {
        try (JsonParser parser = this.asParser();){
            T t = deserializer.deserialize(parser, mapper);
            return t;
        }
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (generator instanceof JacksonJsonpGenerator) {
            JacksonJsonpGenerator jkGenerator = (JacksonJsonpGenerator)generator;
            try {
                this.buffer.serialize(jkGenerator.jacksonGenerator());
            }
            catch (IOException e) {
                throw JacksonUtils.convertException(e);
            }
        }
        try (JsonParser parser = this.asParser();){
            JsonpUtils.copy(parser, generator);
        }
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        JacksonJsonpGenerator generator = new JacksonJsonpGenerator(this.mapper.objectMapper().createGenerator((Writer)writer));
        try {
            this.serialize(generator, this.mapper);
            generator.close();
            String string = writer.toString();
            generator.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    generator.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return String.format("JacksonJsonBuffer: error rendering JSON: %s", e.getMessage());
            }
        }
    }
}

