/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.elasticsearch._types.HealthStatus;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RemoteClusterInfo
implements JsonpSerializable {
    private final String clusterUuid;
    private final String mode;
    private final boolean skipUnavailable;
    private final String transportCompress;
    private final HealthStatus status;
    private final List<String> version;
    private final int nodesCount;
    private final int shardsCount;
    private final int indicesCount;
    private final long indicesTotalSizeInBytes;
    @Nullable
    private final String indicesTotalSize;
    private final long maxHeapInBytes;
    @Nullable
    private final String maxHeap;
    private final long memTotalInBytes;
    @Nullable
    private final String memTotal;
    public static final JsonpDeserializer<RemoteClusterInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RemoteClusterInfo::setupRemoteClusterInfoDeserializer);

    private RemoteClusterInfo(Builder builder) {
        this.clusterUuid = ApiTypeHelper.requireNonNull(builder.clusterUuid, this, "clusterUuid");
        this.mode = ApiTypeHelper.requireNonNull(builder.mode, this, "mode");
        this.skipUnavailable = ApiTypeHelper.requireNonNull(builder.skipUnavailable, (Object)this, "skipUnavailable", false);
        this.transportCompress = ApiTypeHelper.requireNonNull(builder.transportCompress, this, "transportCompress");
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
        this.version = ApiTypeHelper.unmodifiableRequired(builder.version, (Object)this, "version");
        this.nodesCount = ApiTypeHelper.requireNonNull(builder.nodesCount, (Object)this, "nodesCount", 0);
        this.shardsCount = ApiTypeHelper.requireNonNull(builder.shardsCount, (Object)this, "shardsCount", 0);
        this.indicesCount = ApiTypeHelper.requireNonNull(builder.indicesCount, (Object)this, "indicesCount", 0);
        this.indicesTotalSizeInBytes = ApiTypeHelper.requireNonNull(builder.indicesTotalSizeInBytes, (Object)this, "indicesTotalSizeInBytes", 0L);
        this.indicesTotalSize = builder.indicesTotalSize;
        this.maxHeapInBytes = ApiTypeHelper.requireNonNull(builder.maxHeapInBytes, (Object)this, "maxHeapInBytes", 0L);
        this.maxHeap = builder.maxHeap;
        this.memTotalInBytes = ApiTypeHelper.requireNonNull(builder.memTotalInBytes, (Object)this, "memTotalInBytes", 0L);
        this.memTotal = builder.memTotal;
    }

    public static RemoteClusterInfo of(Function<Builder, ObjectBuilder<RemoteClusterInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String clusterUuid() {
        return this.clusterUuid;
    }

    public final String mode() {
        return this.mode;
    }

    public final boolean skipUnavailable() {
        return this.skipUnavailable;
    }

    public final String transportCompress() {
        return this.transportCompress;
    }

    public final HealthStatus status() {
        return this.status;
    }

    public final List<String> version() {
        return this.version;
    }

    public final int nodesCount() {
        return this.nodesCount;
    }

    public final int shardsCount() {
        return this.shardsCount;
    }

    public final int indicesCount() {
        return this.indicesCount;
    }

    public final long indicesTotalSizeInBytes() {
        return this.indicesTotalSizeInBytes;
    }

    @Nullable
    public final String indicesTotalSize() {
        return this.indicesTotalSize;
    }

    public final long maxHeapInBytes() {
        return this.maxHeapInBytes;
    }

    @Nullable
    public final String maxHeap() {
        return this.maxHeap;
    }

    public final long memTotalInBytes() {
        return this.memTotalInBytes;
    }

    @Nullable
    public final String memTotal() {
        return this.memTotal;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cluster_uuid");
        generator.write(this.clusterUuid);
        generator.writeKey("mode");
        generator.write(this.mode);
        generator.writeKey("skip_unavailable");
        generator.write(this.skipUnavailable);
        generator.writeKey("transport.compress");
        generator.write(this.transportCompress);
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.version)) {
            generator.writeKey("version");
            generator.writeStartArray();
            for (String item0 : this.version) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("nodes_count");
        generator.write(this.nodesCount);
        generator.writeKey("shards_count");
        generator.write(this.shardsCount);
        generator.writeKey("indices_count");
        generator.write(this.indicesCount);
        generator.writeKey("indices_total_size_in_bytes");
        generator.write(this.indicesTotalSizeInBytes);
        if (this.indicesTotalSize != null) {
            generator.writeKey("indices_total_size");
            generator.write(this.indicesTotalSize);
        }
        generator.writeKey("max_heap_in_bytes");
        generator.write(this.maxHeapInBytes);
        if (this.maxHeap != null) {
            generator.writeKey("max_heap");
            generator.write(this.maxHeap);
        }
        generator.writeKey("mem_total_in_bytes");
        generator.write(this.memTotalInBytes);
        if (this.memTotal != null) {
            generator.writeKey("mem_total");
            generator.write(this.memTotal);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRemoteClusterInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::clusterUuid, JsonpDeserializer.stringDeserializer(), "cluster_uuid");
        op.add(Builder::mode, JsonpDeserializer.stringDeserializer(), "mode");
        op.add(Builder::skipUnavailable, JsonpDeserializer.booleanDeserializer(), "skip_unavailable");
        op.add(Builder::transportCompress, JsonpDeserializer.stringDeserializer(), "transport.compress");
        op.add(Builder::status, HealthStatus._DESERIALIZER, "status");
        op.add(Builder::version, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "version");
        op.add(Builder::nodesCount, JsonpDeserializer.integerDeserializer(), "nodes_count");
        op.add(Builder::shardsCount, JsonpDeserializer.integerDeserializer(), "shards_count");
        op.add(Builder::indicesCount, JsonpDeserializer.integerDeserializer(), "indices_count");
        op.add(Builder::indicesTotalSizeInBytes, JsonpDeserializer.longDeserializer(), "indices_total_size_in_bytes");
        op.add(Builder::indicesTotalSize, JsonpDeserializer.stringDeserializer(), "indices_total_size");
        op.add(Builder::maxHeapInBytes, JsonpDeserializer.longDeserializer(), "max_heap_in_bytes");
        op.add(Builder::maxHeap, JsonpDeserializer.stringDeserializer(), "max_heap");
        op.add(Builder::memTotalInBytes, JsonpDeserializer.longDeserializer(), "mem_total_in_bytes");
        op.add(Builder::memTotal, JsonpDeserializer.stringDeserializer(), "mem_total");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RemoteClusterInfo> {
        private String clusterUuid;
        private String mode;
        private Boolean skipUnavailable;
        private String transportCompress;
        private HealthStatus status;
        private List<String> version;
        private Integer nodesCount;
        private Integer shardsCount;
        private Integer indicesCount;
        private Long indicesTotalSizeInBytes;
        @Nullable
        private String indicesTotalSize;
        private Long maxHeapInBytes;
        @Nullable
        private String maxHeap;
        private Long memTotalInBytes;
        @Nullable
        private String memTotal;

        public final Builder clusterUuid(String value) {
            this.clusterUuid = value;
            return this;
        }

        public final Builder mode(String value) {
            this.mode = value;
            return this;
        }

        public final Builder skipUnavailable(boolean value) {
            this.skipUnavailable = value;
            return this;
        }

        public final Builder transportCompress(String value) {
            this.transportCompress = value;
            return this;
        }

        public final Builder status(HealthStatus value) {
            this.status = value;
            return this;
        }

        public final Builder version(List<String> list) {
            this.version = Builder._listAddAll(this.version, list);
            return this;
        }

        public final Builder version(String value, String ... values) {
            this.version = Builder._listAdd(this.version, value, values);
            return this;
        }

        public final Builder nodesCount(int value) {
            this.nodesCount = value;
            return this;
        }

        public final Builder shardsCount(int value) {
            this.shardsCount = value;
            return this;
        }

        public final Builder indicesCount(int value) {
            this.indicesCount = value;
            return this;
        }

        public final Builder indicesTotalSizeInBytes(long value) {
            this.indicesTotalSizeInBytes = value;
            return this;
        }

        public final Builder indicesTotalSize(@Nullable String value) {
            this.indicesTotalSize = value;
            return this;
        }

        public final Builder maxHeapInBytes(long value) {
            this.maxHeapInBytes = value;
            return this;
        }

        public final Builder maxHeap(@Nullable String value) {
            this.maxHeap = value;
            return this;
        }

        public final Builder memTotalInBytes(long value) {
            this.memTotalInBytes = value;
            return this;
        }

        public final Builder memTotal(@Nullable String value) {
            this.memTotal = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RemoteClusterInfo build() {
            this._checkSingleUse();
            return new RemoteClusterInfo(this);
        }
    }
}

