/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json;

import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpDeserializerBase;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpMapperFeatures;
import co.elastic.clients.json.JsonpMappingException;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.OpenTaggedUnion;
import co.elastic.clients.util.TaggedUnion;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ExternallyTaggedUnion {
    private ExternallyTaggedUnion() {
    }

    public static <T extends TaggedUnion<?, ?>> JsonpDeserializer<Map<String, List<T>>> arrayMapDeserializer(TypedKeysDeserializer<T> deserializer) {
        return JsonpDeserializer.of(EnumSet.of(JsonParser.Event.START_OBJECT), (parser, mapper, event) -> {
            HashMap result = new HashMap();
            String key = null;
            try {
                while ((event = parser.next()) != JsonParser.Event.END_OBJECT) {
                    JsonpUtils.expectEvent(parser, event, JsonParser.Event.KEY_NAME);
                    key = parser.getString();
                    int hashPos = key.indexOf(35);
                    if (hashPos == -1) {
                        throw new JsonpMappingException("Property name '" + key + "' is not in the 'type#name' format. Make sure the request has 'typed_keys' set.", parser.getLocation()).prepend(null, key);
                    }
                    String type = key.substring(0, hashPos);
                    String name = key.substring(hashPos + 1);
                    ArrayList list = new ArrayList();
                    JsonpUtils.expectNextEvent(parser, JsonParser.Event.START_ARRAY);
                    try {
                        while ((event = parser.next()) != JsonParser.Event.END_ARRAY) {
                            list.add(deserializer.deserializer.deserialize(type, (JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event));
                        }
                    }
                    catch (Exception e) {
                        throw JsonpMappingException.from(e, list.size(), parser);
                    }
                    result.put(name, list);
                }
            }
            catch (Exception e) {
                throw JsonpMappingException.from(e, null, key, parser);
            }
            return result;
        });
    }

    public static <T extends JsonpSerializable & TaggedUnion<? extends JsonEnum, ?>> void serializeTypedKeys(Map<String, T> map, JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        ExternallyTaggedUnion.serializeTypedKeysInner(map, generator, mapper);
        generator.writeEnd();
    }

    public static <T extends JsonpSerializable & TaggedUnion<? extends JsonEnum, ?>> void serializeTypedKeysArray(Map<String, List<T>> map, JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        if (mapper.attribute(JsonpMapperFeatures.SERIALIZE_TYPED_KEYS, true).booleanValue()) {
            for (Map.Entry<String, List<T>> entry : map.entrySet()) {
                List<T> list = entry.getValue();
                if (list.isEmpty()) continue;
                generator.writeKey(ExternallyTaggedUnion.getKind((JsonpSerializable)list.get(0)) + "#" + entry.getKey());
                generator.writeStartArray();
                for (JsonpSerializable value : list) {
                    value.serialize(generator, mapper);
                }
                generator.writeEnd();
            }
        } else {
            for (Map.Entry<String, List<T>> entry : map.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.writeStartArray();
                for (JsonpSerializable value : entry.getValue()) {
                    value.serialize(generator, mapper);
                }
                generator.writeEnd();
            }
        }
        generator.writeEnd();
    }

    public static <T extends JsonpSerializable & TaggedUnion<? extends JsonEnum, ?>> void serializeTypedKeysInner(Map<String, T> map, JsonGenerator generator, JsonpMapper mapper) {
        if (mapper.attribute(JsonpMapperFeatures.SERIALIZE_TYPED_KEYS, true).booleanValue()) {
            for (Map.Entry<String, T> entry : map.entrySet()) {
                JsonpSerializable value = (JsonpSerializable)entry.getValue();
                generator.writeKey(ExternallyTaggedUnion.getKind(value) + "#" + entry.getKey());
                value.serialize(generator, mapper);
            }
        } else {
            for (Map.Entry<String, T> entry : map.entrySet()) {
                generator.writeKey(entry.getKey());
                ((JsonpSerializable)entry.getValue()).serialize(generator, mapper);
            }
        }
    }

    private static <T extends JsonpSerializable & TaggedUnion<? extends JsonEnum, ?>> String getKind(T value) {
        String kind;
        if (value instanceof OpenTaggedUnion) {
            kind = ((OpenTaggedUnion)value)._customKind();
            if (kind == null) {
                kind = ((TaggedUnion<JsonEnum, ?>)value)._kind().jsonValue();
            }
        } else {
            kind = ((TaggedUnion<JsonEnum, ?>)value)._kind().jsonValue();
        }
        return kind;
    }

    public static class TypedKeysDeserializer<Union extends TaggedUnion<?, ?>>
    extends JsonpDeserializerBase<Map<String, Union>> {
        Deserializer<Union, ?> deserializer;

        protected TypedKeysDeserializer(Deserializer<Union, ?> deser) {
            super(EnumSet.of(JsonParser.Event.START_OBJECT));
            this.deserializer = deser;
        }

        @Override
        public Map<String, Union> deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            HashMap result = new HashMap();
            while ((event = parser.next()) != JsonParser.Event.END_OBJECT) {
                JsonpUtils.expectEvent(parser, event, JsonParser.Event.KEY_NAME);
                this.deserializeEntry(parser.getString(), parser, mapper, result);
            }
            return result;
        }

        public void deserializeEntry(String key, JsonParser parser, JsonpMapper mapper, Map<String, Union> targetMap) {
            int hashPos = key.indexOf(35);
            if (hashPos == -1) {
                throw new JsonpMappingException("Property name '" + key + "' is not in the 'type#name' format. Make sure the request has 'typed_keys' set.", parser.getLocation());
            }
            String type = key.substring(0, hashPos);
            String name = key.substring(hashPos + 1);
            targetMap.put(name, this.deserializer.deserialize(type, parser, mapper, parser.next()));
        }
    }

    public static class Deserializer<Union extends TaggedUnion<?, ?>, Member> {
        private final Map<String, JsonpDeserializer<? extends Member>> deserializers;
        private final Function<Member, Union> unionCtor;
        @Nullable
        private final BiFunction<String, JsonData, Union> unknownVariantCtor;

        public Deserializer(Map<String, JsonpDeserializer<? extends Member>> deserializers, Function<Member, Union> unionCtor) {
            this.deserializers = deserializers;
            this.unionCtor = unionCtor;
            this.unknownVariantCtor = null;
        }

        public Deserializer(Map<String, JsonpDeserializer<? extends Member>> deserializers, Function<Member, Union> unionCtor, BiFunction<String, JsonData, Union> unknownVariantCtor) {
            this.deserializers = deserializers;
            this.unionCtor = unionCtor;
            this.unknownVariantCtor = unknownVariantCtor;
        }

        public Union deserialize(String type, JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
            JsonpDeserializer<Member> deserializer = this.deserializers.get(type);
            if (deserializer == null) {
                if (this.unknownVariantCtor == null) {
                    throw new JsonpMappingException("Unknown variant type '" + type + "'", parser.getLocation());
                }
                return (Union)((TaggedUnion)this.unknownVariantCtor.apply(type, JsonData._DESERIALIZER.deserialize(parser, mapper, event)));
            }
            return (Union)((TaggedUnion)this.unionCtor.apply(deserializer.deserialize(parser, mapper, event)));
        }

        public TypedKeysDeserializer<Union> typedKeys() {
            return new TypedKeysDeserializer(this);
        }
    }
}

