/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketBase;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import jakarta.json.stream.JsonGenerator;

public abstract class SignificantTermsBucketBase
extends MultiBucketBase {
    private final double score;
    private final long bgCount;

    protected SignificantTermsBucketBase(AbstractBuilder<?> builder) {
        super(builder);
        this.score = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).score, (Object)this, "score", 0.0);
        this.bgCount = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).bgCount, (Object)this, "bgCount", 0L);
    }

    public final double score() {
        return this.score;
    }

    public final long bgCount() {
        return this.bgCount;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("score");
        generator.write(this.score);
        generator.writeKey("bg_count");
        generator.write(this.bgCount);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupSignificantTermsBucketBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        MultiBucketBase.setupMultiBucketBaseDeserializer(op);
        op.add(AbstractBuilder::score, JsonpDeserializer.doubleDeserializer(), "score");
        op.add(AbstractBuilder::bgCount, JsonpDeserializer.longDeserializer(), "bg_count");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends MultiBucketBase.AbstractBuilder<BuilderT> {
        private Double score;
        private Long bgCount;

        public final BuilderT score(double value) {
            this.score = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT bgCount(long value) {
            this.bgCount = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

