/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ContentObject
implements JsonpSerializable {
    private final String text;
    private final String type;
    public static final JsonpDeserializer<ContentObject> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ContentObject::setupContentObjectDeserializer);

    private ContentObject(Builder builder) {
        this.text = ApiTypeHelper.requireNonNull(builder.text, this, "text");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static ContentObject of(Function<Builder, ObjectBuilder<ContentObject>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String text() {
        return this.text;
    }

    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("text");
        generator.write(this.text);
        generator.writeKey("type");
        generator.write(this.type);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupContentObjectDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::text, JsonpDeserializer.stringDeserializer(), "text");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ContentObject> {
        private String text;
        private String type;

        public final Builder text(String value) {
            this.text = value;
            return this;
        }

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ContentObject build() {
            this._checkSingleUse();
            return new ContentObject(this);
        }
    }
}

