/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class GeoGridQuery
extends QueryBase
implements TaggedUnion<Kind, Object>,
QueryVariant,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    private final String field;
    public static final JsonpDeserializer<GeoGridQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoGridQuery::setupGeoGridQueryDeserializer, Builder::build);

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.GeoGrid;
    }

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private GeoGridQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static GeoGridQuery of(Function<Builder, ObjectBuilder<GeoGridQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String field() {
        return this.field;
    }

    public boolean isGeotile() {
        return this._kind == Kind.Geotile;
    }

    public String geotile() {
        return (String)TaggedUnionUtils.get(this, Kind.Geotile);
    }

    public boolean isGeohash() {
        return this._kind == Kind.Geohash;
    }

    public String geohash() {
        return (String)TaggedUnionUtils.get(this, Kind.Geohash);
    }

    public boolean isGeohex() {
        return this._kind == Kind.Geohex;
    }

    public String geohex() {
        return (String)TaggedUnionUtils.get(this, Kind.Geohex);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Geotile: {
                    generator.write((String)this._value);
                    break;
                }
                case Geohash: {
                    generator.write((String)this._value);
                    break;
                }
                case Geohex: {
                    generator.write((String)this._value);
                }
            }
        }
        generator.writeEnd();
        generator.writeEnd();
    }

    @Override
    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGeoGridQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::geotile, JsonpDeserializer.stringDeserializer(), "geotile");
        op.add(Builder::geohash, JsonpDeserializer.stringDeserializer(), "geohash");
        op.add(Builder::geohex, JsonpDeserializer.stringDeserializer(), "geohex");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoGridQuery> {
        private Kind _kind;
        private Object _value;
        private String field;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<GeoGridQuery> geotile(String v) {
            this._kind = Kind.Geotile;
            this._value = v;
            return this;
        }

        public ObjectBuilder<GeoGridQuery> geohash(String v) {
            this._kind = Kind.Geohash;
            this._value = v;
            return this;
        }

        public ObjectBuilder<GeoGridQuery> geohex(String v) {
            this._kind = Kind.Geohex;
            this._value = v;
            return this;
        }

        @Override
        public GeoGridQuery build() {
            this._checkSingleUse();
            return new GeoGridQuery(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Geotile("geotile"),
        Geohash("geohash"),
        Geohex("geohex");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

