/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.PhoneticEncoder;
import co.elastic.clients.elasticsearch._types.analysis.PhoneticLanguage;
import co.elastic.clients.elasticsearch._types.analysis.PhoneticNameType;
import co.elastic.clients.elasticsearch._types.analysis.PhoneticRuleType;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PhoneticTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    private final PhoneticEncoder encoder;
    private final List<PhoneticLanguage> languageset;
    @Nullable
    private final Integer maxCodeLen;
    @Nullable
    private final PhoneticNameType nameType;
    @Nullable
    private final Boolean replace;
    @Nullable
    private final PhoneticRuleType ruleType;
    public static final JsonpDeserializer<PhoneticTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PhoneticTokenFilter::setupPhoneticTokenFilterDeserializer);

    private PhoneticTokenFilter(Builder builder) {
        super(builder);
        this.encoder = ApiTypeHelper.requireNonNull(builder.encoder, this, "encoder");
        this.languageset = ApiTypeHelper.unmodifiable(builder.languageset);
        this.maxCodeLen = builder.maxCodeLen;
        this.nameType = builder.nameType;
        this.replace = builder.replace;
        this.ruleType = builder.ruleType;
    }

    public static PhoneticTokenFilter of(Function<Builder, ObjectBuilder<PhoneticTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Phonetic;
    }

    public final PhoneticEncoder encoder() {
        return this.encoder;
    }

    public final List<PhoneticLanguage> languageset() {
        return this.languageset;
    }

    @Nullable
    public final Integer maxCodeLen() {
        return this.maxCodeLen;
    }

    @Nullable
    public final PhoneticNameType nameType() {
        return this.nameType;
    }

    @Nullable
    public final Boolean replace() {
        return this.replace;
    }

    @Nullable
    public final PhoneticRuleType ruleType() {
        return this.ruleType;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "phonetic");
        super.serializeInternal(generator, mapper);
        generator.writeKey("encoder");
        this.encoder.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.languageset)) {
            generator.writeKey("languageset");
            generator.writeStartArray();
            for (PhoneticLanguage item0 : this.languageset) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.maxCodeLen != null) {
            generator.writeKey("max_code_len");
            generator.write(this.maxCodeLen.intValue());
        }
        if (this.nameType != null) {
            generator.writeKey("name_type");
            this.nameType.serialize(generator, mapper);
        }
        if (this.replace != null) {
            generator.writeKey("replace");
            generator.write(this.replace.booleanValue());
        }
        if (this.ruleType != null) {
            generator.writeKey("rule_type");
            this.ruleType.serialize(generator, mapper);
        }
    }

    protected static void setupPhoneticTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::encoder, PhoneticEncoder._DESERIALIZER, "encoder");
        op.add(Builder::languageset, JsonpDeserializer.arrayDeserializer(PhoneticLanguage._DESERIALIZER), "languageset");
        op.add(Builder::maxCodeLen, JsonpDeserializer.integerDeserializer(), "max_code_len");
        op.add(Builder::nameType, PhoneticNameType._DESERIALIZER, "name_type");
        op.add(Builder::replace, JsonpDeserializer.booleanDeserializer(), "replace");
        op.add(Builder::ruleType, PhoneticRuleType._DESERIALIZER, "rule_type");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PhoneticTokenFilter> {
        private PhoneticEncoder encoder;
        @Nullable
        private List<PhoneticLanguage> languageset;
        @Nullable
        private Integer maxCodeLen;
        @Nullable
        private PhoneticNameType nameType;
        @Nullable
        private Boolean replace;
        @Nullable
        private PhoneticRuleType ruleType;

        public final Builder encoder(PhoneticEncoder value) {
            this.encoder = value;
            return this;
        }

        public final Builder languageset(List<PhoneticLanguage> list) {
            this.languageset = Builder._listAddAll(this.languageset, list);
            return this;
        }

        public final Builder languageset(PhoneticLanguage value, PhoneticLanguage ... values) {
            this.languageset = Builder._listAdd(this.languageset, value, values);
            return this;
        }

        public final Builder maxCodeLen(@Nullable Integer value) {
            this.maxCodeLen = value;
            return this;
        }

        public final Builder nameType(@Nullable PhoneticNameType value) {
            this.nameType = value;
            return this;
        }

        public final Builder replace(@Nullable Boolean value) {
            this.replace = value;
            return this;
        }

        public final Builder ruleType(@Nullable PhoneticRuleType value) {
            this.ruleType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PhoneticTokenFilter build() {
            this._checkSingleUse();
            return new PhoneticTokenFilter(this);
        }
    }
}

