/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class InvalidateApiKeyResponse
implements JsonpSerializable {
    private final int errorCount;
    private final List<ErrorCause> errorDetails;
    private final List<String> invalidatedApiKeys;
    private final List<String> previouslyInvalidatedApiKeys;
    public static final JsonpDeserializer<InvalidateApiKeyResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InvalidateApiKeyResponse::setupInvalidateApiKeyResponseDeserializer);

    private InvalidateApiKeyResponse(Builder builder) {
        this.errorCount = ApiTypeHelper.requireNonNull(builder.errorCount, (Object)this, "errorCount", 0);
        this.errorDetails = ApiTypeHelper.unmodifiable(builder.errorDetails);
        this.invalidatedApiKeys = ApiTypeHelper.unmodifiableRequired(builder.invalidatedApiKeys, (Object)this, "invalidatedApiKeys");
        this.previouslyInvalidatedApiKeys = ApiTypeHelper.unmodifiableRequired(builder.previouslyInvalidatedApiKeys, (Object)this, "previouslyInvalidatedApiKeys");
    }

    public static InvalidateApiKeyResponse of(Function<Builder, ObjectBuilder<InvalidateApiKeyResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int errorCount() {
        return this.errorCount;
    }

    public final List<ErrorCause> errorDetails() {
        return this.errorDetails;
    }

    public final List<String> invalidatedApiKeys() {
        return this.invalidatedApiKeys;
    }

    public final List<String> previouslyInvalidatedApiKeys() {
        return this.previouslyInvalidatedApiKeys;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("error_count");
        generator.write(this.errorCount);
        if (ApiTypeHelper.isDefined(this.errorDetails)) {
            generator.writeKey("error_details");
            generator.writeStartArray();
            for (ErrorCause errorCause : this.errorDetails) {
                errorCause.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.invalidatedApiKeys)) {
            generator.writeKey("invalidated_api_keys");
            generator.writeStartArray();
            for (String string : this.invalidatedApiKeys) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.previouslyInvalidatedApiKeys)) {
            generator.writeKey("previously_invalidated_api_keys");
            generator.writeStartArray();
            for (String string : this.previouslyInvalidatedApiKeys) {
                generator.write(string);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupInvalidateApiKeyResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::errorCount, JsonpDeserializer.integerDeserializer(), "error_count");
        op.add(Builder::errorDetails, JsonpDeserializer.arrayDeserializer(ErrorCause._DESERIALIZER), "error_details");
        op.add(Builder::invalidatedApiKeys, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "invalidated_api_keys");
        op.add(Builder::previouslyInvalidatedApiKeys, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "previously_invalidated_api_keys");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<InvalidateApiKeyResponse> {
        private Integer errorCount;
        @Nullable
        private List<ErrorCause> errorDetails;
        private List<String> invalidatedApiKeys;
        private List<String> previouslyInvalidatedApiKeys;

        public final Builder errorCount(int value) {
            this.errorCount = value;
            return this;
        }

        public final Builder errorDetails(List<ErrorCause> list) {
            this.errorDetails = Builder._listAddAll(this.errorDetails, list);
            return this;
        }

        public final Builder errorDetails(ErrorCause value, ErrorCause ... values) {
            this.errorDetails = Builder._listAdd(this.errorDetails, value, values);
            return this;
        }

        public final Builder errorDetails(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.errorDetails(fn.apply(new ErrorCause.Builder()).build(), new ErrorCause[0]);
        }

        public final Builder invalidatedApiKeys(List<String> list) {
            this.invalidatedApiKeys = Builder._listAddAll(this.invalidatedApiKeys, list);
            return this;
        }

        public final Builder invalidatedApiKeys(String value, String ... values) {
            this.invalidatedApiKeys = Builder._listAdd(this.invalidatedApiKeys, value, values);
            return this;
        }

        public final Builder previouslyInvalidatedApiKeys(List<String> list) {
            this.previouslyInvalidatedApiKeys = Builder._listAddAll(this.previouslyInvalidatedApiKeys, list);
            return this;
        }

        public final Builder previouslyInvalidatedApiKeys(String value, String ... values) {
            this.previouslyInvalidatedApiKeys = Builder._listAdd(this.previouslyInvalidatedApiKeys, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InvalidateApiKeyResponse build() {
            this._checkSingleUse();
            return new InvalidateApiKeyResponse(this);
        }
    }
}

