/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class HttpInputProxy
implements JsonpSerializable {
    private final String host;
    private final Number port;
    public static final JsonpDeserializer<HttpInputProxy> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HttpInputProxy::setupHttpInputProxyDeserializer);

    private HttpInputProxy(Builder builder) {
        this.host = ApiTypeHelper.requireNonNull(builder.host, this, "host");
        this.port = ApiTypeHelper.requireNonNull(builder.port, this, "port");
    }

    public static HttpInputProxy of(Function<Builder, ObjectBuilder<HttpInputProxy>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String host() {
        return this.host;
    }

    public final Number port() {
        return this.port;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("host");
        generator.write(this.host);
        generator.writeKey("port");
        generator.write(this.port.doubleValue());
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupHttpInputProxyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::host, JsonpDeserializer.stringDeserializer(), "host");
        op.add(Builder::port, JsonpDeserializer.numberDeserializer(), "port");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<HttpInputProxy> {
        private String host;
        private Number port;

        public final Builder host(String value) {
            this.host = value;
            return this;
        }

        public final Builder port(Number value) {
            this.port = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HttpInputProxy build() {
            this._checkSingleUse();
            return new HttpInputProxy(this);
        }
    }
}

