/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher.stats;

import co.elastic.clients.elasticsearch.watcher.ExecutionThreadPool;
import co.elastic.clients.elasticsearch.watcher.stats.WatchRecordQueuedStats;
import co.elastic.clients.elasticsearch.watcher.stats.WatchRecordStats;
import co.elastic.clients.elasticsearch.watcher.stats.WatcherState;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class WatcherNodeStats
implements JsonpSerializable {
    private final List<WatchRecordStats> currentWatches;
    private final ExecutionThreadPool executionThreadPool;
    private final List<WatchRecordQueuedStats> queuedWatches;
    private final long watchCount;
    private final WatcherState watcherState;
    private final String nodeId;
    public static final JsonpDeserializer<WatcherNodeStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WatcherNodeStats::setupWatcherNodeStatsDeserializer);

    private WatcherNodeStats(Builder builder) {
        this.currentWatches = ApiTypeHelper.unmodifiable(builder.currentWatches);
        this.executionThreadPool = ApiTypeHelper.requireNonNull(builder.executionThreadPool, this, "executionThreadPool");
        this.queuedWatches = ApiTypeHelper.unmodifiable(builder.queuedWatches);
        this.watchCount = ApiTypeHelper.requireNonNull(builder.watchCount, (Object)this, "watchCount", 0L);
        this.watcherState = ApiTypeHelper.requireNonNull(builder.watcherState, this, "watcherState");
        this.nodeId = ApiTypeHelper.requireNonNull(builder.nodeId, this, "nodeId");
    }

    public static WatcherNodeStats of(Function<Builder, ObjectBuilder<WatcherNodeStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<WatchRecordStats> currentWatches() {
        return this.currentWatches;
    }

    public final ExecutionThreadPool executionThreadPool() {
        return this.executionThreadPool;
    }

    public final List<WatchRecordQueuedStats> queuedWatches() {
        return this.queuedWatches;
    }

    public final long watchCount() {
        return this.watchCount;
    }

    public final WatcherState watcherState() {
        return this.watcherState;
    }

    public final String nodeId() {
        return this.nodeId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.currentWatches)) {
            generator.writeKey("current_watches");
            generator.writeStartArray();
            for (WatchRecordStats watchRecordStats : this.currentWatches) {
                watchRecordStats.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("execution_thread_pool");
        this.executionThreadPool.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.queuedWatches)) {
            generator.writeKey("queued_watches");
            generator.writeStartArray();
            for (WatchRecordQueuedStats watchRecordQueuedStats : this.queuedWatches) {
                watchRecordQueuedStats.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("watch_count");
        generator.write(this.watchCount);
        generator.writeKey("watcher_state");
        this.watcherState.serialize(generator, mapper);
        generator.writeKey("node_id");
        generator.write(this.nodeId);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupWatcherNodeStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::currentWatches, JsonpDeserializer.arrayDeserializer(WatchRecordStats._DESERIALIZER), "current_watches");
        op.add(Builder::executionThreadPool, ExecutionThreadPool._DESERIALIZER, "execution_thread_pool");
        op.add(Builder::queuedWatches, JsonpDeserializer.arrayDeserializer(WatchRecordQueuedStats._DESERIALIZER), "queued_watches");
        op.add(Builder::watchCount, JsonpDeserializer.longDeserializer(), "watch_count");
        op.add(Builder::watcherState, WatcherState._DESERIALIZER, "watcher_state");
        op.add(Builder::nodeId, JsonpDeserializer.stringDeserializer(), "node_id");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<WatcherNodeStats> {
        @Nullable
        private List<WatchRecordStats> currentWatches;
        private ExecutionThreadPool executionThreadPool;
        @Nullable
        private List<WatchRecordQueuedStats> queuedWatches;
        private Long watchCount;
        private WatcherState watcherState;
        private String nodeId;

        public final Builder currentWatches(List<WatchRecordStats> list) {
            this.currentWatches = Builder._listAddAll(this.currentWatches, list);
            return this;
        }

        public final Builder currentWatches(WatchRecordStats value, WatchRecordStats ... values) {
            this.currentWatches = Builder._listAdd(this.currentWatches, value, values);
            return this;
        }

        public final Builder currentWatches(Function<WatchRecordStats.Builder, ObjectBuilder<WatchRecordStats>> fn) {
            return this.currentWatches(fn.apply(new WatchRecordStats.Builder()).build(), new WatchRecordStats[0]);
        }

        public final Builder executionThreadPool(ExecutionThreadPool value) {
            this.executionThreadPool = value;
            return this;
        }

        public final Builder executionThreadPool(Function<ExecutionThreadPool.Builder, ObjectBuilder<ExecutionThreadPool>> fn) {
            return this.executionThreadPool(fn.apply(new ExecutionThreadPool.Builder()).build());
        }

        public final Builder queuedWatches(List<WatchRecordQueuedStats> list) {
            this.queuedWatches = Builder._listAddAll(this.queuedWatches, list);
            return this;
        }

        public final Builder queuedWatches(WatchRecordQueuedStats value, WatchRecordQueuedStats ... values) {
            this.queuedWatches = Builder._listAdd(this.queuedWatches, value, values);
            return this;
        }

        public final Builder queuedWatches(Function<WatchRecordQueuedStats.Builder, ObjectBuilder<WatchRecordQueuedStats>> fn) {
            return this.queuedWatches(fn.apply(new WatchRecordQueuedStats.Builder()).build(), new WatchRecordQueuedStats[0]);
        }

        public final Builder watchCount(long value) {
            this.watchCount = value;
            return this;
        }

        public final Builder watcherState(WatcherState value) {
            this.watcherState = value;
            return this;
        }

        public final Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WatcherNodeStats build() {
            this._checkSingleUse();
            return new WatcherNodeStats(this);
        }
    }
}

