/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.slm;

import co.elastic.clients.elasticsearch.slm.Retention;
import co.elastic.clients.elasticsearch.slm.SlmConfiguration;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SlmPolicy
implements JsonpSerializable {
    @Nullable
    private final SlmConfiguration config;
    private final String name;
    private final String repository;
    @Nullable
    private final Retention retention;
    private final String schedule;
    public static final JsonpDeserializer<SlmPolicy> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SlmPolicy::setupSlmPolicyDeserializer);

    private SlmPolicy(Builder builder) {
        this.config = builder.config;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.repository = ApiTypeHelper.requireNonNull(builder.repository, this, "repository");
        this.retention = builder.retention;
        this.schedule = ApiTypeHelper.requireNonNull(builder.schedule, this, "schedule");
    }

    public static SlmPolicy of(Function<Builder, ObjectBuilder<SlmPolicy>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final SlmConfiguration config() {
        return this.config;
    }

    public final String name() {
        return this.name;
    }

    public final String repository() {
        return this.repository;
    }

    @Nullable
    public final Retention retention() {
        return this.retention;
    }

    public final String schedule() {
        return this.schedule;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.config != null) {
            generator.writeKey("config");
            this.config.serialize(generator, mapper);
        }
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("repository");
        generator.write(this.repository);
        if (this.retention != null) {
            generator.writeKey("retention");
            this.retention.serialize(generator, mapper);
        }
        generator.writeKey("schedule");
        generator.write(this.schedule);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSlmPolicyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::config, SlmConfiguration._DESERIALIZER, "config");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::repository, JsonpDeserializer.stringDeserializer(), "repository");
        op.add(Builder::retention, Retention._DESERIALIZER, "retention");
        op.add(Builder::schedule, JsonpDeserializer.stringDeserializer(), "schedule");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SlmPolicy> {
        @Nullable
        private SlmConfiguration config;
        private String name;
        private String repository;
        @Nullable
        private Retention retention;
        private String schedule;

        public final Builder config(@Nullable SlmConfiguration value) {
            this.config = value;
            return this;
        }

        public final Builder config(Function<SlmConfiguration.Builder, ObjectBuilder<SlmConfiguration>> fn) {
            return this.config(fn.apply(new SlmConfiguration.Builder()).build());
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder repository(String value) {
            this.repository = value;
            return this;
        }

        public final Builder retention(@Nullable Retention value) {
            this.retention = value;
            return this;
        }

        public final Builder retention(Function<Retention.Builder, ObjectBuilder<Retention>> fn) {
            return this.retention(fn.apply(new Retention.Builder()).build());
        }

        public final Builder schedule(String value) {
            this.schedule = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SlmPolicy build() {
            this._checkSingleUse();
            return new SlmPolicy(this);
        }
    }
}

